/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileResourceImpl;
import org.apache.ctakes.core.resource.JdbcConnectionResourceImpl;
import org.apache.ctakes.dictionary.lookup.ae.DictionaryLookupAnnotator;
import org.apache.ctakes.dictionary.lookup2.util.UmlsUserApprover;
import org.apache.ctakes.utils.env.EnvironmentVariable;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="UMLS Dictionary Lookup (Old)", description="Annotates clinically-relevant terms.  This is an older, slower dictionary lookup implementation.", dependencies={PipeBitInfo.TypeProduct.CHUNK, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class UmlsDictionaryLookupAnnotator
extends DictionaryLookupAnnotator {
    public static final String UMLSADDR_PARAM = "ctakes.umlsaddr";
    public static final String UMLSVENDOR_PARAM = "ctakes.umlsvendor";
    public static final String UMLSUSER_PARAM = "ctakes.umlsuser";
    public static final String UMLSPW_PARAM = "ctakes.umlspw";
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String UMLSAddr;
    private String UMLSVendor;
    private String UMLSUser;
    private String UMLSPW;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.UMLSAddr = EnvironmentVariable.getEnv((String)UMLSADDR_PARAM, (UimaContext)aContext);
            this.UMLSVendor = EnvironmentVariable.getEnv((String)UMLSVENDOR_PARAM, (UimaContext)aContext);
            this.UMLSUser = EnvironmentVariable.getEnv((String)UMLSUSER_PARAM, (UimaContext)aContext);
            this.UMLSPW = EnvironmentVariable.getEnv((String)UMLSPW_PARAM, (UimaContext)aContext);
            this.iv_logger.info((Object)("Using ctakes.umlsaddr: " + this.UMLSAddr + ": " + this.UMLSUser));
            if (!UmlsUserApprover.getInstance().isValidUMLSUser(this.UMLSAddr, this.UMLSVendor, this.UMLSUser, this.UMLSPW)) {
                this.iv_logger.error((Object)"Error: Invalid UMLS License.  A UMLS License is required to use the UMLS dictionary lookup. \nError: You may request one at: https://uts.nlm.nih.gov/license.html \nPlease verify your UMLS license settings in the DictionaryLookupAnnotatorUMLS.xml configuration.");
                throw new Exception("Failed to initilize.  Invalid UMLS License");
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException, MalformedURLException {
        InputStream lookUpStream = UmlsDictionaryLookupAnnotator.class.getClassLoader().getResourceAsStream("org/apache/ctakes/dictionary/lookup/LookupDesc_Db.xml");
        File lookupFile = new File("/tmp/LookupDesc_Db.xml");
        try {
            FileUtils.copyInputStreamToFile((InputStream)lookUpStream, (File)lookupFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying temporary InpuStream org/apache/ctakes/dictionary/lookup/LookupDesc_Db.xml to /tmp/LookupDesc_Db.xml.", e);
        }
        return AnalysisEngineFactory.createEngineDescription(UmlsDictionaryLookupAnnotator.class, (Object[])new Object[]{UMLSADDR_PARAM, "https://uts-ws.nlm.nih.gov/restful/isValidUMLSUser", UMLSVENDOR_PARAM, "NLM-6515182895", "LookupDescriptor", ExternalResourceFactory.createExternalResourceDescription(FileResourceImpl.class, (URL)lookupFile.toURI().toURL(), (Object[])new Object[0]), "DbConnection", ExternalResourceFactory.createExternalResourceDescription(JdbcConnectionResourceImpl.class, (String)"", (Object[])new Object[]{"DriverClassName", "org.hsqldb.jdbcDriver", "URL", "jdbc:hsqldb:res:/org/apache/ctakes/dictionary/lookup/umls2011ab/umls"}), "RxnormIndexReader", ExternalResourceFactory.createExternalResourceDescription(JdbcConnectionResourceImpl.class, (String)"", (Object[])new Object[]{"DriverClassName", "org.hsqldb.jdbcDriver", "URL", "jdbc:hsqldb:res:/org/apache/ctakes/dictionary/lookup/rxnorm-hsqldb/umls"}), "OrangeBookIndexReader", ExternalResourceFactory.createExternalResourceDescription(JdbcConnectionResourceImpl.class, (String)"", (Object[])new Object[]{"DriverClassName", "org.hsqldb.jdbcDriver", "URL", "jdbc:hsqldb:res:/org/apache/ctakes/dictionary/lookup/orange_book_hsqldb/umls"})});
    }
}

