/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.jar.ClassifierBuilder_ImplBase;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.svmlight.model.SvmLightModel;
import org.cleartk.ml.util.featurevector.FeatureVector;

public abstract class SvmLightClassifierBuilder_ImplBase<CLASSIFIER_TYPE extends Classifier<OUTCOME_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>
extends ClassifierBuilder_ImplBase<CLASSIFIER_TYPE, FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> {
    static Logger logger = UIMAFramework.getLogger(SvmLightClassifierBuilder_ImplBase.class);
    public static String COMMAND_ARGUMENT = "--executable";
    protected SvmLightModel model;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.svmlight");
    }

    protected File getModelFile(File dir) {
        return new File(dir, "training-data.svmlight.model");
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        File trainingDataFile = this.getTrainingDataFile(dir);
        this.trainClassifier(dir, trainingDataFile, args);
    }

    public void trainClassifier(File dir, File trainingDataFile, String ... args) throws Exception {
        String executable = "svm_learn";
        if (args.length > 0 && args[0].equals(COMMAND_ARGUMENT)) {
            executable = args[1];
            String[] tempArgs = new String[args.length - 2];
            System.arraycopy(args, 2, tempArgs, 0, tempArgs.length);
            args = tempArgs;
        }
        Object[] command = new String[args.length + 3];
        command[0] = executable;
        System.arraycopy(args, 0, command, 1, args.length);
        command[command.length - 2] = trainingDataFile.getPath();
        command[command.length - 1] = trainingDataFile.getPath() + ".model";
        logger.log(Level.FINE, "training svmlight using the following command: " + Joiner.on((String)" ").join(command));
        Process process = Runtime.getRuntime().exec((String[])command);
        process.getOutputStream().close();
        ByteStreams.copy((InputStream)process.getInputStream(), (OutputStream)System.out);
        ByteStreams.copy((InputStream)process.getErrorStream(), (OutputStream)System.err);
        process.waitFor();
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"model.svmlight", (File)this.getModelFile(dir));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)"model.svmlight");
        this.model = SvmLightModel.fromInputStream(modelStream);
    }
}

