/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.sigmoid.Sigmoid;
import org.cleartk.ml.svmlight.model.SvmLightModel;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightStringOutcomeClassifier
extends Classifier_ImplBase<FeatureVector, String, Integer> {
    Map<Integer, SvmLightModel> models;
    Map<Integer, Sigmoid> sigmoids;

    public SvmLightStringOutcomeClassifier(FeaturesEncoder<FeatureVector> featuresEncoder, OutcomeEncoder<String, Integer> outcomeEncoder, Map<Integer, SvmLightModel> models, Map<Integer, Sigmoid> sigmoids) {
        super(featuresEncoder, outcomeEncoder);
        this.models = models;
        this.sigmoids = sigmoids;
    }

    public String classify(List<Feature> features) throws CleartkProcessingException {
        FeatureVector featureVector = (FeatureVector)this.featuresEncoder.encodeAll(features);
        int maxScoredIndex = 0;
        double maxScore = 0.0;
        boolean first = true;
        for (int i : this.models.keySet()) {
            double score = this.score(featureVector, i);
            if (!first && !(score > maxScore)) continue;
            first = false;
            maxScore = score;
            maxScoredIndex = i;
        }
        return (String)this.outcomeEncoder.decode((Object)maxScoredIndex);
    }

    public Map<String, Double> score(List<Feature> features) throws CleartkProcessingException {
        FeatureVector featureVector = (FeatureVector)this.featuresEncoder.encodeAll(features);
        HashMap results = Maps.newHashMap();
        for (int i : this.models.keySet()) {
            double score = this.score(featureVector, i);
            String name = (String)this.outcomeEncoder.decode((Object)i);
            results.put(name, score);
        }
        return results;
    }

    private double score(FeatureVector fv, int i) {
        return this.sigmoids.get(i).evaluate(this.models.get(i).evaluate(fv));
    }
}

