/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.IntegerRangeCondition;
import org.apache.ctakes.core.fsm.condition.NumberCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.RangeCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.MeasurementToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class MeasurementFSM {
    Set<String> iv_fullTextSet = new HashSet<String>();
    Set<String> iv_shortTextSet = new HashSet<String>();
    Set<String> iv_textNumberSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public MeasurementFSM() {
        this.iv_fullTextSet.add("gallon");
        this.iv_fullTextSet.add("gallons");
        this.iv_fullTextSet.add("pint");
        this.iv_fullTextSet.add("pints");
        this.iv_fullTextSet.add("ounce");
        this.iv_fullTextSet.add("ounces");
        this.iv_fullTextSet.add("pound");
        this.iv_fullTextSet.add("pounds");
        this.iv_fullTextSet.add("drop");
        this.iv_fullTextSet.add("drops");
        this.iv_fullTextSet.add("hour");
        this.iv_fullTextSet.add("hours");
        this.iv_fullTextSet.add("minute");
        this.iv_fullTextSet.add("minutes");
        this.iv_fullTextSet.add("second");
        this.iv_fullTextSet.add("seconds");
        this.iv_fullTextSet.add("foot");
        this.iv_fullTextSet.add("feet");
        this.iv_fullTextSet.add("grain");
        this.iv_fullTextSet.add("grains");
        this.iv_fullTextSet.add("teaspoon");
        this.iv_fullTextSet.add("teaspoons");
        this.iv_fullTextSet.add("tablespoon");
        this.iv_fullTextSet.add("tablespoons");
        this.iv_fullTextSet.add("kilogram");
        this.iv_fullTextSet.add("kilograms");
        this.iv_fullTextSet.add("gram");
        this.iv_fullTextSet.add("grams");
        this.iv_fullTextSet.add("centigram");
        this.iv_fullTextSet.add("centigrams");
        this.iv_fullTextSet.add("milligram");
        this.iv_fullTextSet.add("milligrams");
        this.iv_fullTextSet.add("liter");
        this.iv_fullTextSet.add("liters");
        this.iv_fullTextSet.add("centiliter");
        this.iv_fullTextSet.add("centiliters");
        this.iv_fullTextSet.add("milliliter");
        this.iv_fullTextSet.add("milliliters");
        this.iv_fullTextSet.add("meter");
        this.iv_fullTextSet.add("meters");
        this.iv_fullTextSet.add("centimeter");
        this.iv_fullTextSet.add("centimeters");
        this.iv_fullTextSet.add("millimeter");
        this.iv_fullTextSet.add("millimeters");
        this.iv_shortTextSet.add("gal");
        this.iv_shortTextSet.add("gals");
        this.iv_shortTextSet.add("pt");
        this.iv_shortTextSet.add("pts");
        this.iv_shortTextSet.add("oz");
        this.iv_shortTextSet.add("ozs");
        this.iv_shortTextSet.add("lb");
        this.iv_shortTextSet.add("lbs");
        this.iv_shortTextSet.add("gtts");
        this.iv_shortTextSet.add("hr");
        this.iv_shortTextSet.add("min");
        this.iv_shortTextSet.add("sec");
        this.iv_shortTextSet.add("ft");
        this.iv_shortTextSet.add("gr");
        this.iv_shortTextSet.add("tsp");
        this.iv_shortTextSet.add("tbsp");
        this.iv_shortTextSet.add("g");
        this.iv_shortTextSet.add("kg");
        this.iv_shortTextSet.add("mg");
        this.iv_shortTextSet.add("l");
        this.iv_shortTextSet.add("cl");
        this.iv_shortTextSet.add("ml");
        this.iv_shortTextSet.add("m");
        this.iv_shortTextSet.add("cm");
        this.iv_shortTextSet.add("mm");
        this.iv_shortTextSet.add("cc");
        this.iv_textNumberSet.add("one");
        this.iv_textNumberSet.add("two");
        this.iv_textNumberSet.add("three");
        this.iv_textNumberSet.add("four");
        this.iv_textNumberSet.add("five");
        this.iv_textNumberSet.add("six");
        this.iv_textNumberSet.add("seven");
        this.iv_textNumberSet.add("eight");
        this.iv_textNumberSet.add("nine");
        this.iv_textNumberSet.add("ten");
        this.iv_machineSet.add(this.getBloodPressureMachine());
        this.iv_machineSet.add(this.getSubstanceQuantityMachine());
    }

    private Machine getBloodPressureMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState systolicState = new NamedState("SYSTOLIC");
        NamedState fslashState = new NamedState("FSLASH");
        IntegerRangeCondition systolicCondition = new IntegerRangeCondition(80, 200);
        IntegerRangeCondition diastolicCondition = new IntegerRangeCondition(60, 160);
        PunctuationValueCondition fslashCondition = new PunctuationValueCondition('/');
        startState.addTransition(systolicCondition, systolicState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        systolicState.addTransition(fslashCondition, fslashState);
        systolicState.addTransition((Condition)new AnyCondition(), startState);
        fslashState.addTransition(diastolicCondition, endState);
        fslashState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    private Machine getSubstanceQuantityMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState quanitityState = new NamedState("QUANITITY");
        NumberCondition numberCondition = new NumberCondition();
        WordSetCondition numberTextCondition = new WordSetCondition(this.iv_textNumberSet, false);
        RangeCondition rangeCondition = new RangeCondition();
        WordSetCondition fullTextCondition = new WordSetCondition(this.iv_fullTextSet, false);
        WordSetCondition shortTextCondition = new WordSetCondition(this.iv_shortTextSet, false);
        startState.addTransition(numberCondition, quanitityState);
        startState.addTransition(rangeCondition, quanitityState);
        startState.addTransition(numberTextCondition, quanitityState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        quanitityState.addTransition(fullTextCondition, endState);
        quanitityState.addTransition(shortTextCondition, endState);
        quanitityState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<MeasurementToken> execute(List<? extends BaseToken> tokens, Set<? extends BaseToken> overrideSet) throws Exception {
        HashSet<MeasurementToken> measurementSet = new HashSet<MeasurementToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator<? extends BaseToken> overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            Integer key = new Integer(token.getStartOffset());
            if (overrideOn) {
                if (token.getStartOffset() < overrideEndOffset) continue;
                overrideOn = false;
                overrideEndOffset = -1;
            } else if (overrideTokenMap.containsKey(key)) {
                token = (BaseToken)overrideTokenMap.get(key);
                overrideOn = true;
                overrideEndOffset = token.getEndOffset();
            }
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                MeasurementToken measurementToken = new MeasurementToken(startToken.getStartOffset(), endToken.getEndOffset());
                measurementSet.add(measurementToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return measurementSet;
    }
}

