/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.web.search.ConceptFirstWord;
import org.apache.ctakes.ytex.web.search.ConceptSearchService;

public class ConceptLookupBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConceptLookupBean.class);
    private ConceptSearchService conceptSearchService;
    private ConceptFirstWord currentCUI = new ConceptFirstWord();
    private ConceptFirstWord searchCUI = new ConceptFirstWord();
    private List<SelectItem> matchesList = new ArrayList<SelectItem>();
    public static Comparator<Object> umlsFirstWordComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof ConceptFirstWord ? ConceptLookupBean.formatUMLSFirstWord((ConceptFirstWord)o1) : o1.toString();
            String s2 = o2 instanceof ConceptFirstWord ? ConceptLookupBean.formatUMLSFirstWord((ConceptFirstWord)o2) : o2.toString();
            return s1.compareTo(s2);
        }
    };

    public ConceptSearchService getConceptSearchService() {
        return this.conceptSearchService;
    }

    public void setUmlsFirstWordService(ConceptSearchService umlsFirstWordService) {
        this.conceptSearchService = umlsFirstWordService;
    }

    public ConceptFirstWord getSearchCUI() {
        return this.searchCUI;
    }

    public void setSearchCUI(ConceptFirstWord searchCUI) {
        this.searchCUI = searchCUI;
    }

    public void resetListen(ActionEvent event) {
        this.reset();
    }

    public void reset() {
        this.matchesList.clear();
        this.searchCUI = null;
    }

    public void updateList(ValueChangeEvent event) {
        String searchString = (String)event.getNewValue();
        String term = this.conceptSearchService.getTermByConceptId(searchString);
        if (term != null) {
            ConceptFirstWord cfw = new ConceptFirstWord();
            cfw.setFword(term);
            cfw.setConceptId(searchString);
            cfw.setText(term);
            this.currentCUI = cfw;
            this.matchesList = new ArrayList<SelectItem>(0);
        } else {
            this.setMatches(event);
            if (event.getComponent() instanceof SelectInputText) {
                SelectInputText autoComplete = (SelectInputText)event.getComponent();
                if (autoComplete.getSelectedItem() != null) {
                    this.currentCUI = (ConceptFirstWord)autoComplete.getSelectedItem().getValue();
                } else {
                    ConceptFirstWord tempCUI = this.getMatch(autoComplete.getValue().toString());
                    if (tempCUI != null) {
                        this.currentCUI = tempCUI;
                    }
                }
            }
        }
    }

    public ConceptFirstWord getCurrentCUI() {
        return this.currentCUI;
    }

    public List<SelectItem> getList() {
        return this.matchesList;
    }

    public static String formatUMLSFirstWord(ConceptFirstWord fword) {
        return fword.getText() + " [" + fword.getConceptId() + ']';
    }

    public static ConceptFirstWord extractUMLSFirstWord(String fword) {
        String[] tokens = fword.split("[|]");
        ConceptFirstWord umlsFWord = new ConceptFirstWord();
        if (tokens.length > 1) {
            String cui = tokens[tokens.length - 1];
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tokens.length - 1; ++i) {
                builder.append(tokens[i]);
            }
            String text = builder.toString();
            umlsFWord.setConceptId(cui);
            umlsFWord.setText(text);
        }
        return umlsFWord;
    }

    private ConceptFirstWord getMatch(String value) {
        ConceptFirstWord result = null;
        if (this.matchesList != null) {
            for (SelectItem si : this.matchesList) {
                if (!value.equals(si.getLabel())) continue;
                return (ConceptFirstWord)si.getValue();
            }
        }
        return result;
    }

    private void setMatches(ValueChangeEvent event) {
        Object searchWord = event.getNewValue();
        String searchString = searchWord instanceof SelectItem ? ((SelectItem)searchWord).getLabel() : searchWord.toString();
        if (searchString != null && searchString.length() > 2) {
            List<ConceptFirstWord> cuis = this.conceptSearchService.getConceptByFirstWord(searchString);
            this.matchesList = new ArrayList<SelectItem>(cuis.size());
            for (ConceptFirstWord cui : cuis) {
                this.matchesList.add(new SelectItem((Object)cui, ConceptLookupBean.formatUMLSFirstWord(cui)));
            }
        }
    }
}

