/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.cleartk.ml.Feature;
import org.cleartk.ml.TreeFeature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeatureVectorFeaturesEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.ml.encoder.features.normalizer.NoOpNormalizer;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.util.featurevector.FeatureVector;

@Beta
public class TreeFeatureVectorFeaturesEncoder
implements FeaturesEncoder<TreeFeatureVector> {
    private static final long serialVersionUID = -3144134287152993099L;
    private FeatureVectorFeaturesEncoder nameNumberEncoder;

    public TreeFeatureVectorFeaturesEncoder(int cutoff, NameNumberNormalizer normalizer) {
        this.nameNumberEncoder = new FeatureVectorFeaturesEncoder(cutoff, normalizer);
    }

    public TreeFeatureVectorFeaturesEncoder(int cutoff) {
        this(cutoff, (NameNumberNormalizer)new NoOpNormalizer());
    }

    public TreeFeatureVectorFeaturesEncoder() {
        this(0, (NameNumberNormalizer)new NoOpNormalizer());
    }

    public TreeFeatureVector encodeAll(Iterable<Feature> features) throws CleartkEncoderException {
        ArrayList<Feature> fves = new ArrayList<Feature>();
        LinkedHashMap<String, String> trs = new LinkedHashMap<String, String>();
        for (Feature feature : features) {
            if (feature instanceof TreeFeature || feature.getName() != null && feature.getName().matches("^TK.*")) {
                trs.put(feature.getName(), feature.getValue().toString());
                continue;
            }
            fves.add(feature);
        }
        FeatureVector f = this.nameNumberEncoder.encodeAll(fves);
        TreeFeatureVector tfv = new TreeFeatureVector();
        tfv.setFeatures(f);
        tfv.setTrees(trs);
        return tfv;
    }

    public void finalizeFeatureSet(File outputDirectory) throws IOException {
        this.nameNumberEncoder.finalizeFeatureSet(outputDirectory);
    }

    public void addEncoder(FeatureEncoder<NameNumber> numberEncoder) {
        this.nameNumberEncoder.addEncoder(numberEncoder);
    }

    public void setNormalizer(NameNumberNormalizer normalizer) {
        this.nameNumberEncoder.setNormalizer(normalizer);
    }
}

