/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.extensions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class ExtensionConfig {
    private final String name;
    private Map<String, String> parameters;

    public static ExtensionConfig parse(String parameterizedName) {
        Iterator<String> extListIter = QuoteUtil.splitAt(parameterizedName, ";");
        String extToken = extListIter.next();
        ExtensionConfig ext = new ExtensionConfig(extToken);
        while (extListIter.hasNext()) {
            String extParam = extListIter.next();
            Iterator<String> extParamIter = QuoteUtil.splitAt(extParam, "=");
            String key = extParamIter.next().trim();
            String value = null;
            if (extParamIter.hasNext()) {
                value = extParamIter.next();
            }
            ext.setParameter(key, value);
        }
        return ext;
    }

    public ExtensionConfig(String name) {
        this.name = name;
        this.parameters = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public int getParameter(String key, int defValue) {
        String val = this.parameters.get(key);
        if (val == null) {
            return defValue;
        }
        return Integer.valueOf(val);
    }

    public String getParameter(String key, String defValue) {
        String val = this.parameters.get(key);
        if (val == null) {
            return defValue;
        }
        return val;
    }

    public String getParameterizedName() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (String param : this.parameters.keySet()) {
            str.append(';');
            str.append(param);
            String value = this.parameters.get(param);
            if (value == null) continue;
            str.append('=');
            QuoteUtil.quoteIfNeeded(str, value, ";=");
        }
        return str.toString();
    }

    public Set<String> getParameterKeys() {
        return this.parameters.keySet();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void init(ExtensionConfig other) {
        this.parameters.clear();
        this.parameters.putAll(other.parameters);
    }

    public void setParameter(String key, int value) {
        this.parameters.put(key, Integer.toString(value));
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

