/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.application.ResourceRegistryHolder;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.util.Util;
import org.icefaces.util.EnvUtils;

public class ResourceRegistry
extends ResourceHandlerWrapper {
    private static Logger log = Logger.getLogger(ResourceRegistry.class.getName());
    private ResourceHandler wrapped;
    private static String CURRENT_KEY = "org.icefaces.resourceRegistry.resourceKey";
    private static String RESOURCE_PREFIX = "/javax.faces.resource/";
    private static String MAP_PREFIX = "org.icefaces.resource-";

    public ResourceRegistry(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        Application application = facesContext.getApplication();
        String key = ResourceRegistry.extractResourceId(facesContext);
        if (null == key) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        ELContext elContext = facesContext.getELContext();
        ResourceRegistryHolder holder = (ResourceRegistryHolder)elContext.getELResolver().getValue(elContext, null, (Object)(MAP_PREFIX + key));
        if (null == holder) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        Resource resource = holder.resource;
        String contentType = resource.getContentType();
        if (contentType != null) {
            externalContext.setResponseContentType(resource.getContentType());
        }
        InputStream in = resource.getInputStream();
        OutputStream out = externalContext.getResponseOutputStream();
        if (Util.acceptGzip(externalContext) && EnvUtils.isCompressResources(facesContext) && Util.shouldCompress(resource.getContentType())) {
            externalContext.setResponseHeader("Content-Encoding", "gzip");
            Util.compressStream(in, out);
        } else {
            Util.copyStream(in, out);
        }
    }

    public static String addResource(Map scopeMap, Resource resource) {
        return ResourceRegistry.addResource("r", scopeMap, resource);
    }

    private static String addResource(String prefix, Map scopeMap, Resource resource) {
        String key;
        String name = resource.getResourceName();
        if (null != name && name.length() > 0) {
            key = name;
        } else {
            int index = ResourceRegistry.getNextKey();
            key = prefix + String.valueOf(index);
        }
        ResourceRegistryHolder holder = new ResourceRegistryHolder(key, resource);
        scopeMap.put(MAP_PREFIX + key, holder);
        String[] pathTemplate = EnvUtils.getPathTemplate();
        return pathTemplate[0] + key + pathTemplate[1];
    }

    private static String extractResourceId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String path = externalContext.getRequestServletPath();
        if (!path.startsWith(RESOURCE_PREFIX)) {
            return null;
        }
        try {
            String key = path.substring(RESOURCE_PREFIX.length(), path.length() - EnvUtils.getPathTemplate()[1].length());
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource getResourceByPath(FacesContext facesContext, String resPath) {
        if (resPath == null) {
            return null;
        }
        int prefixIndex = resPath.lastIndexOf(RESOURCE_PREFIX);
        if (prefixIndex < 0) {
            return null;
        }
        String key = resPath.substring(prefixIndex + RESOURCE_PREFIX.length(), resPath.length() - EnvUtils.getPathTemplate()[1].length());
        ELContext elContext = facesContext.getELContext();
        ResourceRegistryHolder holder = (ResourceRegistryHolder)elContext.getELResolver().getValue(elContext, null, (Object)(MAP_PREFIX + key));
        if (null == holder) {
            return null;
        }
        return holder.resource;
    }

    private static synchronized int getNextKey() {
        Map appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        Integer currentKey = (Integer)appMap.get(CURRENT_KEY);
        if (null == currentKey) {
            currentKey = new Integer(1);
        }
        currentKey = new Integer(currentKey + 1);
        appMap.put(CURRENT_KEY, currentKey);
        return currentKey;
    }

    public static String addApplicationResource(Resource resource) {
        return ResourceRegistry.addResource("a", FacesContext.getCurrentInstance().getExternalContext().getApplicationMap(), resource);
    }

    public static String addSessionResource(Resource resource) {
        return ResourceRegistry.addResource("s", FacesContext.getCurrentInstance().getExternalContext().getSessionMap(), resource);
    }

    public static String addFlashResource(Resource resource) {
        return ResourceRegistry.addResource("f", (Map)FacesContext.getCurrentInstance().getExternalContext().getFlash(), resource);
    }

    public static String addViewResource(Resource resource) {
        return ResourceRegistry.addResource("v", FacesContext.getCurrentInstance().getViewRoot().getViewMap(), resource);
    }

    public static String addWindowResource(Resource resource) {
        return ResourceRegistry.addResource("w", WindowScopeManager.lookupWindowScope(FacesContext.getCurrentInstance()), resource);
    }
}

