/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.metadata.type;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData_Type;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP_Type;
import org.apache.uima.jcas.tcas.DocumentAnnotation;

public class DocumentMetaData
extends DocumentAnnotation {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected DocumentMetaData() {
    }

    public DocumentMetaData(int addr, TOP_Type type) {
        super(addr, type);
        this.readObject();
    }

    public DocumentMetaData(JCas jcas) {
        super(jcas);
        this.readObject();
    }

    public DocumentMetaData(JCas jcas, int begin, int end) {
        super(jcas);
        this.setBegin(begin);
        this.setEnd(end);
        this.readObject();
    }

    private void readObject() {
    }

    public String getDocumentTitle() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentTitle == null) {
            this.jcasType.jcas.throwFeatMissing("documentTitle", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentTitle);
    }

    public void setDocumentTitle(String v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentTitle == null) {
            this.jcasType.jcas.throwFeatMissing("documentTitle", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentTitle, v);
    }

    public String getDocumentId() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentId == null) {
            this.jcasType.jcas.throwFeatMissing("documentId", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentId);
    }

    public void setDocumentId(String v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentId == null) {
            this.jcasType.jcas.throwFeatMissing("documentId", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentId, v);
    }

    public String getDocumentUri() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentUri == null) {
            this.jcasType.jcas.throwFeatMissing("documentUri", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentUri);
    }

    public void setDocumentUri(String v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentUri == null) {
            this.jcasType.jcas.throwFeatMissing("documentUri", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentUri, v);
    }

    public String getCollectionId() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_collectionId == null) {
            this.jcasType.jcas.throwFeatMissing("collectionId", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_collectionId);
    }

    public void setCollectionId(String v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_collectionId == null) {
            this.jcasType.jcas.throwFeatMissing("collectionId", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_collectionId, v);
    }

    public String getDocumentBaseUri() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentBaseUri == null) {
            this.jcasType.jcas.throwFeatMissing("documentBaseUri", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentBaseUri);
    }

    public void setDocumentBaseUri(String v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_documentBaseUri == null) {
            this.jcasType.jcas.throwFeatMissing("documentBaseUri", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_documentBaseUri, v);
    }

    public boolean getIsLastSegment() {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_isLastSegment == null) {
            this.jcasType.jcas.throwFeatMissing("isLastSegment", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        return this.jcasType.ll_cas.ll_getBooleanValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_isLastSegment);
    }

    public void setIsLastSegment(boolean v) {
        if (DocumentMetaData_Type.featOkTst && ((DocumentMetaData_Type)this.jcasType).casFeat_isLastSegment == null) {
            this.jcasType.jcas.throwFeatMissing("isLastSegment", "de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData");
        }
        this.jcasType.ll_cas.ll_setBooleanValue(this.addr, ((DocumentMetaData_Type)this.jcasType).casFeatCode_isLastSegment, v);
    }

    public static DocumentMetaData create(CAS aCas) throws IllegalStateException, CASException {
        try {
            DocumentMetaData.get(aCas);
            throw new IllegalStateException("CAS already contains DocumentMetaData");
        }
        catch (IllegalArgumentException e) {
            DocumentMetaData docMetaData = new DocumentMetaData(aCas.getJCas());
            DocumentMetaData.initDocumentMetaData(docMetaData);
            return docMetaData;
        }
    }

    public static DocumentMetaData create(JCas aJcas) throws IllegalStateException {
        try {
            DocumentMetaData.get(aJcas);
            throw new IllegalStateException("CAS already contains DocumentMetaData");
        }
        catch (IllegalArgumentException e) {
            DocumentMetaData docMetaData = new DocumentMetaData(aJcas);
            DocumentMetaData.initDocumentMetaData(docMetaData);
            return docMetaData;
        }
    }

    private static DocumentMetaData initDocumentMetaData(DocumentMetaData aMetaData) {
        DocumentAnnotation da = DocumentMetaData.getDocumentAnnotation(aMetaData.getView());
        if (da != null) {
            aMetaData.setLanguage(da.getLanguage());
            aMetaData.setBegin(da.getBegin());
            aMetaData.setEnd(da.getEnd());
            da.removeFromIndexes();
        } else if (aMetaData.getView().getDocumentText() != null) {
            aMetaData.setBegin(0);
            aMetaData.setEnd(aMetaData.getView().getDocumentText().length());
        }
        aMetaData.addToIndexes();
        return aMetaData;
    }

    public static void copy(JCas aSourceView, JCas aTargetView) throws AnalysisEngineProcessException {
        DocumentMetaData docMetaData = DocumentMetaData.create(aTargetView);
        DocumentMetaData dmd = DocumentMetaData.get(aSourceView);
        docMetaData.setCollectionId(dmd.getCollectionId());
        docMetaData.setDocumentBaseUri(dmd.getDocumentBaseUri());
        docMetaData.setDocumentId(dmd.getDocumentId());
        docMetaData.setDocumentTitle(dmd.getDocumentTitle());
        docMetaData.setDocumentUri(dmd.getDocumentUri());
        docMetaData.setIsLastSegment(dmd.getIsLastSegment());
    }

    public static DocumentMetaData get(CAS aCas) {
        FSIterator iterator = aCas.getIndexRepository().getAllIndexedFS(CasUtil.getType((CAS)aCas, DocumentMetaData.class));
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException(new Throwable("CAS does not contain any " + DocumentMetaData.class.getName()));
        }
        DocumentMetaData result = (DocumentMetaData)((Object)iterator.next());
        if (iterator.hasNext()) {
            throw new IllegalArgumentException(new Throwable("CAS contains more than one " + DocumentMetaData.class.getName()));
        }
        return result;
    }

    private static DocumentAnnotation getDocumentAnnotation(CAS aCas) {
        FSIterator iterator = aCas.getIndexRepository().getAllIndexedFS(CasUtil.getType((CAS)aCas, DocumentAnnotation.class));
        if (!iterator.hasNext()) {
            return null;
        }
        DocumentAnnotation result = (DocumentAnnotation)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException(new Throwable("CAS contains more than one " + DocumentAnnotation.class.getName()));
        }
        return result;
    }

    public static DocumentMetaData get(JCas aJCas) {
        return DocumentMetaData.get(aJCas.getCas());
    }

    static {
        type = typeIndexID = JCasRegistry.register(DocumentMetaData.class);
    }
}

