/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.w3c.dom.Document;

public final class XSLTUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTUtils.class);

    private XSLTUtils() {
    }

    public static InputStream transform(Templates xsltTemplate, InputStream in) {
        try {
            StreamSource beforeSource = new StreamSource(in);
            CachedOutputStream out = new CachedOutputStream();
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new StreamResult((OutputStream)out));
            return out.getInputStream();
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static Reader transform(Templates xsltTemplate, Reader inReader) {
        try {
            StreamSource beforeSource = new StreamSource(inReader);
            CachedWriter outWriter = new CachedWriter();
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new StreamResult((Writer)outWriter));
            return outWriter.getReader();
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static Document transform(Templates xsltTemplate, Document in) {
        try {
            DOMSource beforeSource = new DOMSource(in);
            Document out = DOMUtils.createDocument();
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new DOMResult(out));
            return out;
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

