/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.reader.TextMessageUtil;

public class ActiveMQTextMessage
extends ActiveMQMessage
implements TextMessage {
    public static final byte TYPE = 3;
    private SimpleString text;

    public ActiveMQTextMessage(ClientSession session) {
        super((byte)3, session);
    }

    public ActiveMQTextMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQTextMessage(TextMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)3, session);
        this.setText(foreign.getText());
    }

    @Override
    public byte getType() {
        return 3;
    }

    public void setText(String text) throws JMSException {
        this.checkWrite();
        this.text = text != null ? SimpleString.of((String)text) : null;
        TextMessageUtil.writeBodyText((ActiveMQBuffer)this.message.getBodyBuffer(), (SimpleString)this.text);
    }

    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    @Override
    public void doBeforeReceive() throws ActiveMQException {
        super.doBeforeReceive();
        this.text = TextMessageUtil.readBodyText((ActiveMQBuffer)this.message.getBodyBuffer());
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        return (T)this.getText();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.text == null) {
            return true;
        }
        return c.isAssignableFrom(String.class);
    }
}

