/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class SampleSketchUDF
extends UDF {
    public static final int DEFAULT_SIZE = 16384;

    public BytesWritable evaluate(BytesWritable binarySketch, int sketchSize, float probability) {
        if (binarySketch == null) {
            return null;
        }
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)binarySketch);
        if (serializedSketch.getCapacity() <= 8L) {
            return null;
        }
        Union union = SetOperation.builder().setP(probability).setNominalEntries(sketchSize).buildUnion();
        union.union(serializedSketch);
        CompactSketch intermediateSketch = union.getResult(false, null);
        byte[] resultSketch = intermediateSketch.toByteArray();
        BytesWritable result = new BytesWritable();
        result.set(resultSketch, 0, resultSketch.length);
        return result;
    }
}

