/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class BufferReadWriteSafetyTest {
    private final WritableBuffer buf = (WritableBuffer)Buffer.wrap((ByteBuffer)ByteBuffer.allocate(8));

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutByte() {
        this.buf.setPosition(0L);
        this.buf.putByte(0L, (byte)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutBytePositional() {
        this.buf.setPosition(0L);
        this.buf.putByte((byte)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutShort() {
        this.buf.setPosition(0L);
        this.buf.putShort(0L, (short)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutShortPositional() {
        this.buf.setPosition(0L);
        this.buf.putShort((short)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutChar() {
        this.buf.setPosition(0L);
        this.buf.putChar(0L, '\u0001');
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutCharPositional() {
        this.buf.setPosition(0L);
        this.buf.putChar('\u0001');
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutInt() {
        this.buf.setPosition(0L);
        this.buf.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutIntPositional() {
        this.buf.setPosition(0L);
        this.buf.putInt(1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutLong() {
        this.buf.setPosition(0L);
        this.buf.putLong(0L, 1L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutLongPositional() {
        this.buf.setPosition(0L);
        this.buf.putLong(1L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutFloat() {
        this.buf.setPosition(0L);
        this.buf.putFloat(0L, 1.0f);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutFloatPositional() {
        this.buf.setPosition(0L);
        this.buf.putFloat(1.0f);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutDouble() {
        this.buf.setPosition(0L);
        this.buf.putDouble(0L, 1.0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutDoublePositional() {
        this.buf.setPosition(0L);
        this.buf.putDouble(1.0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutByteArray() {
        this.buf.setPosition(0L);
        this.buf.putByteArray(new byte[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutShortArray() {
        this.buf.setPosition(0L);
        this.buf.putShortArray(new short[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutCharArray() {
        this.buf.setPosition(0L);
        this.buf.putCharArray(new char[]{'\u0001'}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutIntArray() {
        this.buf.setPosition(0L);
        this.buf.putIntArray(new int[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutLongArray() {
        this.buf.setPosition(0L);
        this.buf.putLongArray(new long[]{1L}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutFloatArray() {
        this.buf.setPosition(0L);
        this.buf.putFloatArray(new float[]{1.0f}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDoubleByteArray() {
        this.buf.setPosition(0L);
        this.buf.putDoubleArray(new double[]{1.0}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWritableMemoryAsBuffer() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asBuffer();
        buf1.putInt(1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWritableBufferRegion() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asWritableBuffer().region();
        buf1.putInt(1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWritableBufferDuplicate() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asWritableBuffer().duplicate();
        buf1.putInt(1);
    }
}

