/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.pig.hll.DataToSketchTest;
import org.apache.datasketches.pig.hll.UnionSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final BagFactory bagFactory = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionSketch func = new UnionSketch("10");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void execEmptyBag() throws Exception {
        UnionSketch func = new UnionSketch("10", "HLL_6");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test
    public void execNormalCase() throws Exception {
        UnionSketch func = new UnionSketch();
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update(1L);
        inputSketch.update(2L);
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void accumulator() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update(1L);
        inputSketch.update(2L);
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        func.accumulate(tupleFactory.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getInitial()).newInstance();
        Tuple input = tupleFactory.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicIntermediateNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).getConstructor(String.class).newInstance("10");
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void algebraicIntermediateFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).getConstructor(String.class, String.class).newInstance("10", "HLL_6");
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update(1L);
        inputSketch.update(2L);
        inputSketch.update(3L);
        DataBag outerBag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        outerBag.add(tupleFactory.newTuple((Object)innerBag));
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)outerBag));
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test
    public void algebraicIntermediateFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void algebraicFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).getConstructor(String.class).newInstance("10");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void algebraicFinalFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).getConstructor(String.class, String.class).newInstance("10", "HLL_6");
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update(1L);
        inputSketch.update(2L);
        inputSketch.update(3L);
        DataBag outerBag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        outerBag.add(tupleFactory.newTuple((Object)innerBag));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)outerBag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test
    public void algebraicFinalFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }
}

