/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.ErrorBounds;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ErrorBoundsTest {
    @Test
    public void testNullEmpty() throws IOException {
        ErrorBounds func = new ErrorBounds();
        Tuple dataTuple = null;
        Tuple result = (Tuple)func.exec(dataTuple);
        Assert.assertNull((Object)result);
        dataTuple = TupleFactory.getInstance().newTuple(0);
        result = (Tuple)func.exec(dataTuple);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testExactModeBounds() throws IOException {
        ErrorBounds func = new ErrorBounds();
        int nomEntries = 128;
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(nomEntries, 0, 64));
        Tuple result = (Tuple)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)64.0, (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)64.0, (double)0.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)64.0, (double)0.0);
    }

    @Test
    public void testEstModeBounds() throws IOException {
        ErrorBounds func = new ErrorBounds();
        int nomEntries = 4096;
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromAlphaRange(nomEntries, 0, 2 * nomEntries));
        Tuple result = (Tuple)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        double est = (Double)result.get(0);
        double ub = (Double)result.get(1);
        double lb = (Double)result.get(2);
        double epsilon2SD = 2.0 / Math.sqrt(2 * nomEntries);
        Assert.assertTrue(((double)(2 * nomEntries) < ub && (double)(2 * nomEntries) > lb ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(ub / (est + epsilon2SD * est) - 1.0) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(lb / (est - epsilon2SD * est) - 1.0) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testEstModeBoundsWithSeed() throws IOException {
        ErrorBounds func = new ErrorBounds(Long.toString(9001L));
        int nomEntries = 4096;
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromAlphaRange(nomEntries, 0, 2 * nomEntries));
        Tuple result = (Tuple)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        double est = (Double)result.get(0);
        double ub = (Double)result.get(1);
        double lb = (Double)result.get(2);
        double epsilon2SD = 2.0 / Math.sqrt(2 * nomEntries);
        Assert.assertTrue(((double)(2 * nomEntries) < ub && (double)(2 * nomEntries) > lb ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(ub / (est + epsilon2SD * est) - 1.0) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(lb / (est - epsilon2SD * est) - 1.0) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void outputSchemaTest() throws IOException {
        ErrorBounds udf = new ErrorBounds();
        Schema inputSchema = null;
        Schema.FieldSchema inputFieldSchema = new Schema.FieldSchema("Sketch", 50);
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputInnerFs0 = null;
        Schema.FieldSchema outputInnerFs1 = null;
        Schema.FieldSchema outputInnerFs2 = null;
        inputSchema = new Schema(inputFieldSchema);
        nullOutputSchema = udf.outputSchema(null);
        outputSchema = udf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        outputInnerFs1 = outputInnerSchema.getField(1);
        outputInnerFs2 = outputInnerSchema.getField(2);
        Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) schema may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        expected = "double";
        Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        Assert.assertNotNull((Object)outputInnerFs1, (String)"innerSchema.getField(1) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs1.type);
        Assert.assertEquals((String)result, (String)expected);
        Assert.assertNotNull((Object)outputInnerFs2, (String)"innerSchema.getField(2) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs2.type);
        Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS).append("outputInnerFs1: ").append(outputInnerFs1).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs1.type)).append(PigTestingUtil.LS).append("outputInnerFs2: ").append(outputInnerFs2).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs2.type)).append(PigTestingUtil.LS);
        ErrorBoundsTest.println(sb.toString());
    }

    @Test
    public void printlnTest() {
        ErrorBoundsTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

