/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class DoubleSummarySketchToPercentile
extends EvalFunc<Double> {
    private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();
    private static final int QUANTILES_SKETCH_SIZE = 1024;

    public Double exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            throw new IllegalArgumentException("expected two inputs: sketch and pecentile");
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])dba.get()), SUMMARY_DESERIALIZER);
        double percentile = (Double)input.get(1);
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("percentile must be between 0 and 100");
        }
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(1024).build();
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            qs.update(((DoubleSummary)it.getSummary()).getValue());
        }
        return qs.getQuantile(percentile / 100.0);
    }
}

