/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.Random;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RecoverBadLog
extends T_Generic {
    private String testService = "BadLogTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    private RandomAccessFile infofile = null;
    private boolean setup;
    private boolean test1;
    private boolean test2;
    private boolean test3;
    private boolean test4;
    private boolean test5;
    private boolean test6;
    private boolean test7;
    private boolean checksumTest;
    private String infoPath = "extinout/T_RecoverBadLog.info";
    private static final String TEST_BADLOG_SETUP = "TestBadLogSetup";
    private static final String TEST_BADLOG1 = "TestBadLog1";
    private static final String TEST_BADLOG2 = "TestBadLog2";
    private static final String TEST_BADLOG3 = "TestBadLog3";
    private static final String TEST_BADLOG4 = "TestBadLog4";
    private static final String TEST_BADLOG5 = "TestBadLog5";
    private static final String TEST_BADLOG6 = "TestBadLog6";
    private static final String TEST_BADLOG7 = "TestBadLog7";
    private static final String TEST_BAD_CHECKSUM_LOG = "TestBadChecksumLog";
    private static final String TEST_BADLOG_INFO = "TestBadLogInfo";
    private static final String TEST_BADCHECKSUMLOG_INFO = "TestBadChecksumLogInfo";
    RawStoreFactory factory;
    LockFactory lf;
    LogToFile logFactory;
    ContextService contextService;
    T_Util t_util;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String string = PropertyUtil.getSystemProperty((String)TEST_BADLOG_SETUP);
        this.setup = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG1);
        this.test1 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG2);
        this.test2 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG3);
        this.test3 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG4);
        this.test4 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG5);
        this.test5 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG6);
        this.test6 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BADLOG7);
        this.test7 = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_BAD_CHECKSUM_LOG);
        this.checksumTest = Boolean.valueOf(string);
        if (this.checksumTest) {
            this.infoPath = "extinout/T_RecoverBadChecksumLog.info";
            this.testService = "BadChecksumLogTest";
        }
    }

    @Override
    public void runTests() throws T_Fail {
        this.getConfig();
        int n = 0;
        if (this.setup) {
            ++n;
        }
        if (this.test1) {
            ++n;
        }
        if (this.test2) {
            ++n;
        }
        if (this.test3) {
            ++n;
        }
        if (this.test4) {
            ++n;
        }
        if (this.test5) {
            ++n;
        }
        if (this.test6) {
            ++n;
        }
        if (this.test7) {
            ++n;
        }
        if (n != 1) {
            throw T_Fail.testFailMsg("One & only one of the bad log recovery test should be run");
        }
        this.REPORT("recoverBadLog cannot be run on an insane server");
    }

    private long find(long l) {
        if (this.infofile == null) {
            return -1L;
        }
        try {
            this.infofile.seek(0L);
            while (true) {
                long l2;
                if ((l2 = this.infofile.readLong()) == l) {
                    long l3 = this.infofile.readLong();
                    return l3;
                }
                this.infofile.readLong();
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long key(int n, int n2) {
        long l = n;
        return (l << 32) + (long)n2;
    }

    private void register(long l, long l2) throws T_Fail {
        try {
            this.infofile.seek(this.infofile.length());
            this.infofile.writeLong(l);
            this.infofile.writeLong(l2);
        }
        catch (IOException iOException) {
            T_Fail.exceptionFail(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest1() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        this.factory.checkpoint();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
            String string = "01234567890123456789";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n, (String)null);
                }
            }
            if (n == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page2, new T_RawStoreRow(REC_001));
            this.factory.checkpoint();
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(n * 20));
            }
            this.logFactory.flushAll();
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test1: cid = " + l + " numcol " + n);
            this.register(this.key(1, 1), l);
            this.register(this.key(1, 2), n);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest1() throws T_Fail, StandardException {
        long l = this.find(this.key(1, 1));
        if (l < 0L) {
            this.REPORT("bad log test1 not run");
            return;
        }
        int n = (int)this.find(this.key(1, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest1 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest2() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n;
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n2 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n2);
            String string = "01234567890123456789";
            for (int i = 0; i < n2; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n2 > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n2, (String)null);
                }
            }
            if (n2 == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (n = 0; n < n2; ++n) {
                t_RawStoreRow.setColumn(n, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(n2 * 20));
            }
            this.logFactory.flushAll();
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test2: cid = " + l + " numcol " + n2);
            this.register(this.key(2, 1), l);
            this.register(this.key(2, 2), n2);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest2() throws T_Fail, StandardException {
        long l = this.find(this.key(2, 1));
        if (l < 0L) {
            this.REPORT("bad log test2 not run");
            return;
        }
        int n = (int)this.find(this.key(2, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest2 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest3() throws T_Fail, StandardException {
        int n = 7;
        int n2 = 7;
        try {
            int n3;
            int n4;
            T_TWC[] t_TWCArray = new T_TWC[n];
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4] = this.t_util.t_startTransactionWithContext();
            }
            long[] lArray = new long[n];
            ContainerHandle[] containerHandleArray = new ContainerHandle[n];
            for (n4 = 0; n4 < n; ++n4) {
                lArray[n4] = this.t_util.t_addContainer(t_TWCArray[n4], 0L);
                this.t_util.t_commit(t_TWCArray[n4]);
                containerHandleArray[n4] = this.t_util.t_openContainer(t_TWCArray[n4], 0L, lArray[n4], true);
            }
            Page[][] pageArray = new Page[n][n2];
            long[][] lArray2 = new long[n][n2];
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    t_TWCArray[n4].switchTransactionContext();
                    pageArray[n4][n3] = this.t_util.t_addPage(containerHandleArray[n4]);
                    lArray2[n4][n3] = pageArray[n4][n3].getPageNumber();
                    t_TWCArray[n4].resetContext();
                }
            }
            RecordHandle[][] recordHandleArray = new RecordHandle[n][n2];
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    t_TWCArray[n4].switchTransactionContext();
                    recordHandleArray[n4][n3] = T_Util.t_insert(pageArray[n4][n3], t_RawStoreRow);
                    t_TWCArray[n4].resetContext();
                }
            }
            t_TWCArray[0].setSavePoint(SP1, null);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    t_TWCArray[n4].switchTransactionContext();
                    int n5 = pageArray[n4][n3].getSlotNumber(recordHandleArray[n4][n3]);
                    pageArray[n4][n3].updateAtSlot(n5, (Object[])t_RawStoreRow2.getRow(), null);
                    t_TWCArray[n4].resetContext();
                }
            }
            for (n4 = 1; n4 < n; ++n4) {
                t_TWCArray[n4].setSavePoint(SP1, null);
            }
            this.factory.checkpoint();
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    int n6 = pageArray[n4][n3].getSlotNumber(recordHandleArray[n4][n3]);
                    pageArray[n4][n3].updateAtSlot(n6, (Object[])t_RawStoreRow3.getRow(), null);
                }
            }
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4].setSavePoint(SP2, null);
            }
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    int n7 = pageArray[n4][n3].getSlotNumber(recordHandleArray[n4][n3]);
                    pageArray[n4][n3].updateAtSlot(n7, (Object[])t_RawStoreRow4.getRow(), null);
                }
                t_TWCArray[n4].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n3 = 0; n3 < n2; ++n3) {
                pageArray[0][n3].unlatch();
            }
            t_TWCArray[0].rollbackToSavePoint(SP1, null);
            for (n3 = 0; n3 < n2; ++n3) {
                pageArray[0][n3] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n3]);
            }
            t_TWCArray[0].resetContext();
            this.factory.checkpoint();
            for (n4 = 1; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    T_Util.t_checkFetch(pageArray[n4][n3], recordHandleArray[n4][n3], REC_004);
                }
                t_TWCArray[n4].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n3 = 0; n3 < n2; ++n3) {
                T_Util.t_checkFetch(pageArray[0][n3], recordHandleArray[0][n3], REC_001);
            }
            t_TWCArray[0].resetContext();
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    int n8 = pageArray[n4][n3].getSlotNumber(recordHandleArray[n4][n3]);
                    pageArray[n4][n3].updateAtSlot(n8, (Object[])t_RawStoreRow5.getRow(), null);
                }
                t_TWCArray[n4].resetContext();
            }
            for (n4 = 1; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    pageArray[n4][n3].unlatch();
                }
                t_TWCArray[n4].rollbackToSavePoint(SP2, null);
                for (n3 = 0; n3 < n2; ++n3) {
                    pageArray[n4][n3] = this.t_util.t_getPage(containerHandleArray[n4], lArray2[n4][n3]);
                }
                t_TWCArray[n4].resetContext();
            }
            for (n4 = 1; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    T_Util.t_checkFetch(pageArray[n4][n3], recordHandleArray[n4][n3], REC_003);
                }
                t_TWCArray[n4].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n3 = 0; n3 < n2; ++n3) {
                T_Util.t_checkFetch(pageArray[0][n3], recordHandleArray[0][n3], REC_005);
            }
            t_TWCArray[0].resetContext();
            this.factory.checkpoint();
            T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(REC_006);
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    int n9 = pageArray[n4][n3].getSlotNumber(recordHandleArray[n4][n3]);
                    pageArray[n4][n3].updateAtSlot(n9, (Object[])t_RawStoreRow6.getRow(), null);
                }
                t_TWCArray[n4].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n3 = 0; n3 < n2; ++n3) {
                pageArray[0][n3].unlatch();
            }
            t_TWCArray[0].rollbackToSavePoint(SP1, null);
            for (n3 = 0; n3 < n2; ++n3) {
                pageArray[0][n3] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n3]);
            }
            t_TWCArray[0].resetContext();
            for (n4 = 1; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    T_Util.t_checkFetch(pageArray[n4][n3], recordHandleArray[n4][n3], REC_006);
                    T_Util.t_checkRecordCount(pageArray[n4][n3], 1, 1);
                }
                t_TWCArray[n4].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n3 = 0; n3 < n2; ++n3) {
                T_Util.t_checkFetch(pageArray[0][n3], recordHandleArray[0][n3], REC_001);
                T_Util.t_checkRecordCount(pageArray[0][n3], 1, 1);
            }
            t_TWCArray[0].resetContext();
            for (n4 = 0; n4 < n; ++n4) {
                t_TWCArray[n4].switchTransactionContext();
                for (n3 = 0; n3 < n2; ++n3) {
                    pageArray[n4][n3].unlatch();
                }
                t_TWCArray[n4].resetContext();
            }
            this.t_util.t_abort(t_TWCArray[1]);
            this.t_util.t_commit(t_TWCArray[2]);
            this.t_util.t_commit(t_TWCArray[4]);
            containerHandleArray[1] = this.t_util.t_openContainer(t_TWCArray[1], 0L, lArray[1], false);
            containerHandleArray[2] = this.t_util.t_openContainer(t_TWCArray[2], 0L, lArray[2], false);
            containerHandleArray[4] = this.t_util.t_openContainer(t_TWCArray[4], 0L, lArray[4], false);
            for (n3 = 0; n3 < n2; ++n3) {
                t_TWCArray[0].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[0], recordHandleArray[0][n3], REC_001);
                t_TWCArray[0].resetContext();
                t_TWCArray[1].switchTransactionContext();
                pageArray[1][n3] = this.t_util.t_getPage(containerHandleArray[1], lArray2[1][n3]);
                T_Util.t_checkRecordCount(pageArray[1][n3], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[1][n3], 0, REC_001, true, false);
                pageArray[1][n3].unlatch();
                t_TWCArray[1].resetContext();
                t_TWCArray[2].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[2], recordHandleArray[2][n3], REC_006);
                t_TWCArray[2].resetContext();
                t_TWCArray[3].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[3], recordHandleArray[3][n3], REC_006);
                t_TWCArray[3].resetContext();
                t_TWCArray[4].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[4], recordHandleArray[4][n3], REC_006);
                t_TWCArray[4].resetContext();
            }
            t_TWCArray[3].switchTransactionContext();
            Page page = this.t_util.t_addPage(containerHandleArray[3]);
            Page page2 = this.t_util.t_addPage(containerHandleArray[3]);
            n4 = 0;
            T_RawStoreRow t_RawStoreRow7 = new T_RawStoreRow("row at slot " + n4);
            while (page.spaceForInsert()) {
                if (T_Util.t_insertAtSlot(page, n4, t_RawStoreRow7, (byte)2) == null) break;
                t_RawStoreRow7 = new T_RawStoreRow("row at slot " + ++n4);
            }
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, "200");
            }
            this.logFactory.flushAll();
            page.copyAndPurge(page2, 0, n4, 0);
            t_TWCArray[3].resetContext();
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test3: numtrans " + n + " numpages " + n2);
            for (n4 = 0; n4 < n; ++n4) {
                this.register(this.key(3, n4 + 10), lArray[n4]);
                String string = "container " + n4 + ":" + this.find(this.key(3, n4 + 10)) + " pages: ";
                for (n3 = 0; n3 < n2; ++n3) {
                    string = string + lArray2[n4][n3] + " ";
                    this.register(this.key(3, (n4 + 1) * 1000 + n3), lArray2[n4][n3]);
                }
                this.REPORT("\t" + string);
            }
            this.register(this.key(3, 1), n);
            this.register(this.key(3, 2), n2);
            this.register(this.key(3, 3), page.getPageNumber());
            this.register(this.key(3, 4), page2.getPageNumber());
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest3() throws T_Fail, StandardException {
        int n;
        int n2;
        int n3 = (int)this.find(this.key(3, 1));
        if (n3 < 0) {
            this.REPORT("bad log test3 not run");
            return;
        }
        int n4 = (int)this.find(this.key(3, 2));
        long l = this.find(this.key(3, 3));
        long l2 = this.find(this.key(3, 4));
        Transaction transaction = this.t_util.t_startTransaction();
        long[] lArray = new long[n3];
        ContainerHandle[] containerHandleArray = new ContainerHandle[n3];
        long[][] lArray2 = new long[n3][n4];
        Page[][] pageArray = new Page[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            lArray[n2] = this.find(this.key(3, n2 + 10));
            containerHandleArray[n2] = this.t_util.t_openContainer(transaction, 0L, lArray[n2], true);
            for (n = 0; n < n4; ++n) {
                lArray2[n2][n] = this.find(this.key(3, (n2 + 1) * 1000 + n));
                pageArray[n2][n] = this.t_util.t_getPage(containerHandleArray[n2], lArray2[n2][n]);
            }
        }
        try {
            for (n = 0; n < n4; ++n) {
                T_Util.t_checkRecordCount(pageArray[0][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[0][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[1][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[1][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[2][n], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[2][n], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(pageArray[3][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[3][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[4][n], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[4][n], 0, REC_006, false, true);
            }
            Page page = this.t_util.t_getPage(containerHandleArray[3], l);
            Page page2 = this.t_util.t_getPage(containerHandleArray[3], l2);
            T_Util.t_checkRecordCount(page, 0, 0);
            T_Util.t_checkRecordCount(page2, 0, 0);
            this.REPORT("RTest3 passed: numtrans " + n3 + " numpages " + n4);
            for (n2 = 0; n2 < n3; ++n2) {
                String string = "container " + n2 + ":" + lArray[n2] + " pages: ";
                for (n = 0; n < n4; ++n) {
                    string = string + lArray2[n2][n] + " ";
                }
                this.REPORT("\t" + string);
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest4() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
            String string = "01234567890123456789";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n, (String)null);
                }
            }
            if (n == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(11));
            }
            this.logFactory.flushAll();
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test4: cid = " + l + " numcol " + n);
            this.register(this.key(4, 1), l);
            this.register(this.key(4, 2), n);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest4() throws T_Fail, StandardException {
        long l = this.find(this.key(4, 1));
        if (l < 0L) {
            this.REPORT("bad log test4 not run");
            return;
        }
        int n = (int)this.find(this.key(4, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest4 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest5() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
            String string = "01234567890123456789";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n, (String)null);
                }
            }
            if (n == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(3));
            }
            this.logFactory.flushAll();
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test5: cid = " + l + " numcol " + n);
            this.register(this.key(5, 1), l);
            this.register(this.key(5, 2), n);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest5() throws T_Fail, StandardException {
        long l = this.find(this.key(5, 1));
        if (l < 0L) {
            this.REPORT("bad log test5 not run");
            return;
        }
        int n = (int)this.find(this.key(5, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest5 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest6() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
            String string = "01234567890123456789";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n, (String)null);
                }
            }
            if (n == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(1014));
            }
            this.logFactory.flushAll();
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test6: cid = " + l + " numcol " + n);
            this.register(this.key(6, 1), l);
            this.register(this.key(6, 2), n);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest6() throws T_Fail, StandardException {
        long l = this.find(this.key(6, 1));
        if (l < 0L) {
            this.REPORT("bad log test6 not run");
            return;
        }
        int n = (int)this.find(this.key(6, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest6 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest7() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
            String string = "01234567890123456789";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string);
            }
            RecordHandle recordHandle = null;
            while (n > 0) {
                try {
                    recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    break;
                }
                catch (StandardException standardException) {
                    t_RawStoreRow.setColumn(--n, (String)null);
                }
            }
            if (n == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(transaction);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < n; ++i) {
                t_RawStoreRow.setColumn(i, string2);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(2012));
            }
            this.logFactory.flushAll();
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test7: cid = " + l + " numcol " + n);
            this.register(this.key(7, 1), l);
            this.register(this.key(7, 2), n);
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest7() throws T_Fail, StandardException {
        long l = this.find(this.key(6, 1));
        if (l < 0L) {
            this.REPORT("bad log test7 not run");
            return;
        }
        int n = (int)this.find(this.key(6, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = 40;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n3);
            for (int i = 0; i < n3; ++i) {
                t_RawStoreRow.setColumn(i, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
            String string = "01234567890123456789";
            for (n2 = 0; n2 < n; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.toString().equals(string)) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " value incorrect, got :" + dataValueDescriptor.toString());
            }
            for (n2 = n; n2 < n3; ++n2) {
                DataValueDescriptor dataValueDescriptor = t_RawStoreRow.getStorableColumn(n2);
                if (dataValueDescriptor.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + n2 + " expect Null, got : " + dataValueDescriptor.toString());
            }
            this.REPORT("RTest7 passed");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    private void simulateLogFileCorruption() throws T_Fail, StandardException {
        LogCounter logCounter = (LogCounter)this.logFactory.getFirstUnflushedInstant();
        long l = logCounter.getLogFileNumber();
        long l2 = logCounter.getLogFilePosition();
        this.logFactory.flushAll();
        logCounter = (LogCounter)this.logFactory.getFirstUnflushedInstant();
        l = logCounter.getLogFileNumber();
        long l3 = logCounter.getLogFilePosition() - l2;
        try {
            StorageRandomAccessFile storageRandomAccessFile = this.logFactory.getLogFileToSimulateCorruption(l);
            int n = (int)l3 / 512;
            l2 += 512L;
            Random random = new Random();
            for (int i = 0; i < n; ++i) {
                this.REPORT("corruptig log file : filenum " + l + " fileposition " + l2);
                storageRandomAccessFile.seek(l2);
                storageRandomAccessFile.writeInt(random.nextInt());
                l2 += 512L;
            }
            storageRandomAccessFile.sync();
            storageRandomAccessFile.close();
        }
        catch (IOException iOException) {
            throw T_Fail.exceptionFail(iOException);
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule((Object)object, (String)string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static boolean startPersistentService(final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return Monitor.startPersistentService((String)string, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object createPersistentService(final String string, final String string2, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

