/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import junit.framework.AssertionFailedError;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionPoolDataSourceConnector
implements Connector {
    private TestConfiguration config;
    private ConnectionPoolDataSource ds;

    @Override
    public void setConfiguration(TestConfiguration testConfiguration) {
        this.config = testConfiguration;
        this.ds = J2EEDataSource.getConnectionPoolDataSource(testConfiguration, null);
        ConnectionPoolDataSourceConnector.enableStatementPooling(this.ds);
    }

    private static void enableStatementPooling(ConnectionPoolDataSource connectionPoolDataSource) {
        try {
            J2EEDataSource.setBeanProperty(connectionPoolDataSource, "maxStatements", 2);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    @Override
    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException sQLException) {
            String string;
            String string2 = string = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getPooledConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String string) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException sQLException) {
            String string2;
            String string3 = string2 = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string2.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            ConnectionPoolDataSource connectionPoolDataSource = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
            return connectionPoolDataSource.getPooledConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String string, String string2) throws SQLException {
        try {
            return this.ds.getPooledConnection(string, string2).getConnection();
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getPooledConnection(string, string2).getConnection();
        }
    }

    @Override
    public Connection openConnection(String string, String string2, String string3) throws SQLException {
        return this.openConnection(string, string2, string3, null);
    }

    @Override
    public Connection openConnection(String string, String string2, String string3, Properties properties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getPooledConnection(string2, string3).getConnection();
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            HashMap<String, Object> hashMap = DataSourceConnector.makeCreateDBAttributes(this.config);
            DataSourceConnector.copyProperties(properties, hashMap);
            ConnectionPoolDataSource connectionPoolDataSource = this.singleUseDS(hashMap);
            JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
            return connectionPoolDataSource.getPooledConnection(string2, string3).getConnection();
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getPooledConnection().getConnection();
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean bl) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config));
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", "");
        connectionPoolDataSource.getPooledConnection();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.ds.setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public String getDatabaseName() {
        String string = null;
        try {
            string = (String)JDBCDataSource.getBeanProperty(this.ds, "databaseName");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private ConnectionPoolDataSource singleUseDS(HashMap hashMap) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource(this.config, hashMap);
        ConnectionPoolDataSourceConnector.enableStatementPooling(connectionPoolDataSource);
        return connectionPoolDataSource;
    }
}

