/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.SpecialFunctionNode;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor type;
    DataValueDescriptor defaultValue;
    DefaultInfoImpl defaultInfo;
    DefaultNode defaultNode;
    boolean keepCurrentDefault;
    GenerationClauseNode generationClauseNode;
    long autoincrementIncrement;
    long autoincrementStart;
    boolean autoincrementCycle;
    long autoinc_create_or_modify_Start_Increment;
    boolean autoincrementVerify;
    public static final int CREATE_AUTOINCREMENT = 0;
    public static final int MODIFY_AUTOINCREMENT_RESTART_VALUE = 1;
    public static final int MODIFY_AUTOINCREMENT_INC_VALUE = 2;
    public static final int MODIFY_AUTOINCREMENT_ALWAYS_VS_DEFAULT = 3;
    public static final int MODIFY_AUTOINCREMENT_CYCLE_VALUE = 4;

    ColumnDefinitionNode(String name, ValueNode defaultNode, DataTypeDescriptor dataTypeServices, long[] autoIncrementInfo, ContextManager cm) throws StandardException {
        super(name, cm);
        this.type = dataTypeServices;
        if (defaultNode instanceof UntypedNullConstantNode) {
            if (dataTypeServices != null) {
                this.defaultValue = ((UntypedNullConstantNode)defaultNode).convertDefaultNode(this.type);
            }
        } else if (defaultNode instanceof GenerationClauseNode) {
            this.generationClauseNode = (GenerationClauseNode)defaultNode;
        } else {
            if (defaultNode != null && !(defaultNode instanceof DefaultNode)) {
                SanityManager.THROWASSERT("defaultNode expected to be instanceof DefaultNode, not " + defaultNode.getClass().getName());
            }
            this.defaultNode = (DefaultNode)defaultNode;
            if (autoIncrementInfo != null) {
                long[] aii = autoIncrementInfo;
                this.autoincrementStart = aii[0];
                this.autoincrementIncrement = aii[1];
                this.autoincrementCycle = aii[4] == 1L;
                this.autoinc_create_or_modify_Start_Increment = aii[3];
                this.autoincrementVerify = aii[2] <= 0L;
                this.isAutoincrement = true;
                if (dataTypeServices != null) {
                    this.setNullability(false);
                }
            }
        }
        this.keepCurrentDefault = defaultNode == null;
    }

    @Override
    public String toString() {
        return "type: " + this.getType() + "\ndefaultValue: " + this.defaultValue + "\n" + super.toString();
    }

    String getColumnName() {
        return this.name;
    }

    final DataTypeDescriptor getType() {
        return this.type;
    }

    public void setType(DataTypeDescriptor dts) {
        this.type = dts;
    }

    final void setNullability(boolean nullable) {
        this.type = this.getType().getNullabilityType(nullable);
    }

    void setCollationType(int collationType) {
        this.type = this.getType().getCollatedType(collationType, 1);
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    DefaultInfo getDefaultInfo() {
        return this.defaultInfo;
    }

    public void setDefaultInfo(DefaultInfoImpl dii) {
        this.defaultInfo = dii;
    }

    DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean hasGenerationClause() {
        return this.generationClauseNode != null;
    }

    GenerationClauseNode getGenerationClauseNode() {
        return this.generationClauseNode;
    }

    boolean isAutoincrementColumn() {
        if (this.isAutoincrement && this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            SanityManager.THROWASSERT("autoincrementIncrement expected to be non-zero");
        }
        if (!(this.isAutoincrement || this.autoincrementStart == 0L && this.autoincrementIncrement == 0L)) {
            SanityManager.THROWASSERT("both autoincrementStart and autoincrementIncrement expected to be 0");
        }
        return this.isAutoincrement;
    }

    long getAutoincrementStart() {
        SanityManager.ASSERT(this.isAutoincrement, "isAutoincrement expected to be true");
        return this.autoincrementStart;
    }

    long getAutoincrementIncrement() {
        SanityManager.ASSERT(this.isAutoincrement, "isAutoincrement expected to be true");
        return this.autoincrementIncrement;
    }

    boolean getAutoincrementCycle() {
        SanityManager.ASSERT(this.isAutoincrement, "isAutoincrement expected to be true");
        return this.autoincrementCycle;
    }

    long getAutoinc_create_or_modify_Start_Increment() {
        SanityManager.ASSERT(this.isAutoincrement, "isAutoincrement expected to be true");
        return this.autoinc_create_or_modify_Start_Increment;
    }

    void checkUserType(TableDescriptor td) throws StandardException {
        if (this.hasGenerationClause() && this.getType() == null) {
            return;
        }
        if (!this.getType().getTypeId().userType()) {
            return;
        }
        this.setType(this.bindUserType(this.getType()));
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String columnTypeName = this.getType().getTypeId().getCorrespondingJavaTypeName();
        boolean foundMatch = false;
        ClassNotFoundException reason = null;
        try {
            foundMatch = classInspector.accessible(columnTypeName);
        }
        catch (ClassNotFoundException cnfe) {
            reason = cnfe;
        }
        if (!foundMatch) {
            throw StandardException.newException("42X26", reason, columnTypeName, this.name);
        }
        if (!classInspector.assignableTo(columnTypeName, "java.io.Serializable") && !classInspector.assignableTo(columnTypeName, "java.sql.SQLData")) {
            this.getCompilerContext().addWarning(StandardException.newWarning("01J04", columnTypeName, this.name));
        }
    }

    UUID getOldDefaultUUID() {
        return null;
    }

    int getAction() {
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (!(td == null || this.hasGenerationClause() || this.getType().isNullable() || this.defaultNode != null || this.isAutoincrement)) {
            throw StandardException.newException("42601", this.getColumnName());
        }
        if (this.defaultNode == null) {
            return;
        }
        if (this.defaultValue != null) {
            return;
        }
        this.validateDefault(dd, td);
    }

    void validateAutoincrement(DataDictionary dd, TableDescriptor td, int tableType) throws StandardException {
        if (!this.isAutoincrement) {
            return;
        }
        if (tableType == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        if (this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            throw StandardException.newException("42Z21", this.getColumnName());
        }
        int jdbctype = this.getType().getTypeId().getJDBCTypeId();
        switch (jdbctype) {
            case -6: {
                this.autoincrementCheckRange(-128L, 127L, "TINYINT");
                break;
            }
            case 5: {
                this.autoincrementCheckRange(-32768L, 32767L, "SMALLINT");
                break;
            }
            case 4: {
                this.autoincrementCheckRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "INTEGER");
                break;
            }
            case -5: {
                this.autoincrementCheckRange(Long.MIN_VALUE, Long.MAX_VALUE, "BIGINT");
                break;
            }
            default: {
                throw StandardException.newException("42Z22", this.getColumnName());
            }
        }
    }

    private void autoincrementCheckRange(long minValue, long maxValue, String typeName) throws StandardException {
        if (minValue > this.autoincrementIncrement || maxValue < this.autoincrementIncrement) {
            throw StandardException.newException("22003", typeName);
        }
        if (minValue > this.autoincrementStart || maxValue < this.autoincrementStart) {
            throw StandardException.newException("22003", typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (this.defaultNode == null) {
            return;
        }
        if (this.isAutoincrement) {
            this.defaultInfo = ColumnDefinitionNode.createDefaultInfoOfAutoInc();
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        ValueNode defaultTree = this.defaultNode.getDefaultTree();
        int previousReliability = cc.getReliability();
        try {
            ProviderList apl = null;
            ProviderList prevAPL = null;
            apl = new ProviderList();
            prevAPL = cc.getCurrentAuxiliaryProviderList();
            cc.setCurrentAuxiliaryProviderList(apl);
            cc.setReliability(1192);
            defaultTree = defaultTree.bindExpression(new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
            TypeId columnTypeId = this.getType().getTypeId();
            TypeId defaultTypeId = defaultTree.getTypeId();
            if (!this.defaultTypeIsValid(columnTypeId, this.getType(), defaultTypeId, defaultTree, this.defaultNode.getDefaultText())) {
                throw StandardException.newException("42894", this.name);
            }
            if (!this.getTypeCompiler(columnTypeId).storable(defaultTypeId, this.getClassFactory())) {
                throw StandardException.newException("42821", columnTypeId.getSQLTypeName(), defaultTypeId.getSQLTypeName());
            }
            this.defaultInfo = new DefaultInfoImpl(false, this.defaultNode.getDefaultText(), this.defaultValue);
            if (apl.size() > 0) {
                SanityManager.THROWASSERT("DEFAULT clause has unexpected dependencies");
            }
            cc.setCurrentAuxiliaryProviderList(prevAPL);
        }
        finally {
            cc.setReliability(previousReliability);
        }
    }

    protected static DefaultInfoImpl createDefaultInfoOfAutoInc() {
        return new DefaultInfoImpl(true, null, null);
    }

    boolean defaultTypeIsValid(TypeId columnType, DataTypeDescriptor columnDesc, TypeId defaultType, ValueNode defaultNode, String defaultText) throws StandardException {
        int defType;
        int colType = columnType.getTypeFormatId();
        int n = defType = defaultType == null ? -1 : defaultType.getTypeFormatId();
        if (!defaultNode.isConstantExpression()) {
            boolean charCol;
            boolean bl = charCol = colType == 5 || colType == 13 || colType == 230;
            if (defaultNode instanceof SpecialFunctionNode) {
                switch (((SpecialFunctionNode)defaultNode).kind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return charCol && columnDesc.getMaximumWidth() >= 8;
                    }
                    case 2: {
                        return charCol && columnDesc.getMaximumWidth() >= 128;
                    }
                }
                return false;
            }
        }
        switch (colType) {
            case 4: {
                return defaultNode instanceof BooleanConstantNode;
            }
            case 7: {
                return defType == 7;
            }
            case 11: {
                return defType == 7 || defType == 11;
            }
            case 197: {
                if (defType == 197) {
                    DataTypeDescriptor defDesc = defaultNode.getTypeServices();
                    int len = defaultText.length();
                    int precision = defDesc.getPrecision();
                    int scale = defDesc.getScale();
                    int i = 1;
                    while (i <= scale && defaultText.charAt(len - i) == '0') {
                        --scale;
                        --precision;
                    }
                    return scale <= columnDesc.getScale() && precision - scale <= columnDesc.getPrecision() - columnDesc.getScale();
                }
                return defType == 11 || defType == 7;
            }
            case 5: 
            case 13: 
            case 230: {
                return defType == 5;
            }
            case 27: 
            case 29: 
            case 232: {
                return defType == 27;
            }
            case 267: {
                return defType == colType;
            }
            case 6: 
            case 8: 
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.defaultNode != null) {
            this.printLabel(depth, "default: ");
            this.defaultNode.treePrint(depth + 1);
        }
        if (this.generationClauseNode != null) {
            this.printLabel(depth, "generationClause: ");
            this.generationClauseNode.treePrint(depth + 1);
        }
    }
}

