/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;

public abstract class KnuthSequence
extends ArrayList {
    public KnuthSequence() {
    }

    public KnuthSequence(List list) {
        super(list);
    }

    public void startSequence() {
    }

    public abstract KnuthSequence endSequence();

    public abstract boolean canAppendSequence(KnuthSequence var1);

    public abstract boolean appendSequence(KnuthSequence var1, boolean var2, BreakElement var3);

    public abstract boolean appendSequence(KnuthSequence var1);

    public boolean appendSequenceOrClose(KnuthSequence sequence) {
        if (!this.appendSequence(sequence)) {
            this.endSequence();
            return false;
        }
        return true;
    }

    public boolean appendSequenceOrClose(KnuthSequence sequence, boolean keepTogether, BreakElement breakElement) {
        if (!this.appendSequence(sequence, keepTogether, breakElement)) {
            this.endSequence();
            return false;
        }
        return true;
    }

    public void wrapPositions(LayoutManager lm) {
        ListIterator listIter = this.listIterator();
        while (listIter.hasNext()) {
            ListElement element = (ListElement)listIter.next();
            element.setPosition(lm.notifyPos(new NonLeafPosition(lm, element.getPosition())));
        }
    }

    public ListElement getLast() {
        int idx = this.size();
        if (idx == 0) {
            return null;
        }
        return (ListElement)this.get(idx - 1);
    }

    public ListElement removeLast() {
        int idx = this.size();
        if (idx == 0) {
            return null;
        }
        return (ListElement)this.remove(idx - 1);
    }

    public ListElement getElement(int index) {
        return (ListElement)this.get(index);
    }

    public abstract boolean isInlineSequence();
}

