/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InListMultiProbeTest
extends BaseJDBCTestCase {
    private static final String DATA_TABLE = "CHANGES";
    private static final String COLUMN_NAMES = "KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID";
    private static final String DERBY_6045_DATA_TABLE = "VARIABLE_TERM";
    private static final String CREATE_DERBY_6045_DATA_TABLE = "CREATE TABLE VARIABLE_TERM (term_id INTEGER NOT NULL, var_name VARCHAR(1024) NOT NULL, var_type SMALLINT NOT NULL )";
    private static final String DERBY_6045_DATA_TABLE2 = "MT_GAF_TOP_LEVEL_TERM_COUNTS";
    private static final String CREATE_DERBY_6045_DATA_TABLE2 = "CREATE TABLE MT_GAF_TOP_LEVEL_TERM_COUNTS(mt BIGINT NOT NULL, term BIGINT NOT NULL, term_index INTEGER NOT NULL, usage_count BIGINT NOT NULL )";
    private static final String CREATE_DATA_TABLE = "CREATE TABLE CHANGES (ID BIGINT NOT NULL ,KIND VARCHAR(250) NOT NULL ,ITEM_UUID CHAR(23) NOT NULL ,ITEM_TYPE VARCHAR(250) NOT NULL ,BEFORE CHAR(23), AFTER CHAR(23),FOREIGN_KEY_UUID CHAR(23) NOT NULL)";
    private static final String SELECT_ALL = "Select KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID From CHANGES";
    private static final String SELECT_ALL_WHERE_IN = "Select KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID From CHANGES where FOREIGN_KEY_UUID in (";
    private static final String ORDER_BY = ") order by ID";
    private static final String RUNTIME_STATS_ON_QUERY = "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)";
    private static final String RUNTIME_STATS_OFF_QUERY = "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)";
    private static final String GET_RUNTIME_STATS_QUERY = "VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()";
    private static char[] uuid_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int NUM_ROWS = 30000;
    protected String[] allIds;
    protected TreeMap<String, List<DataRow>> foreignIdToRowsMap;
    private static String[] DERBY_3603_Objects = new String[]{"create table d3603_a (a_id integer, c_id integer)", "create table d3603_c (c_id integer not null, primary key(c_id), d_id integer, t_o bigint, t_i bigint)", "insert into d3603_a (a_id, c_id) values (1, 1)", "insert into d3603_a (a_id, c_id) values (2, 2)", "insert into d3603_a (a_id, c_id) values (3, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (1, 1, 1, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (2, 2, 1, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (21, 1, 1, 1)"};

    public InListMultiProbeTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.foreignIdToRowsMap = null;
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("IN-list MultiProbe Suite");
        suite.addTest(TestConfiguration.embeddedSuite(InListMultiProbeTest.class));
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int numDataRows;
                s.executeUpdate(InListMultiProbeTest.CREATE_DATA_TABLE);
                int BATCH_SIZE = 1000;
                Random random = new Random(1L);
                for (numDataRows = 30000; numDataRows >= 1000; numDataRows -= 1000) {
                    InListMultiProbeTest.insertNDataRows(s.getConnection(), 1000, random);
                }
                if (numDataRows > 0) {
                    InListMultiProbeTest.insertNDataRows(s.getConnection(), numDataRows, random);
                }
                String ddl = "CREATE INDEX CHANGES_NDX1 ON CHANGES(FOREIGN_KEY_UUID, ID)";
                s.executeUpdate(ddl);
                ddl = "ALTER TABLE CHANGES ADD CONSTRAINT CHANGES_PK PRIMARY KEY (ID)";
                s.executeUpdate(ddl);
                for (int i = 0; i < DERBY_3603_Objects.length; ++i) {
                    s.executeUpdate(DERBY_3603_Objects[i]);
                }
            }
        };
    }

    public void testDerby6045DeleteTest() throws SQLException {
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE2);
        s.executeUpdate(CREATE_DERBY_6045_DATA_TABLE2);
        s.executeUpdate("ALTER TABLE MT_GAF_TOP_LEVEL_TERM_COUNTS ADD CONSTRAINT kb_mt_gaf_top_level_term_counts_pk PRIMARY KEY (mt, term, term_index)");
        s.executeUpdate("CREATE INDEX kb_mt_gaf_top_level_term_counts_mt_index ON MT_GAF_TOP_LEVEL_TERM_COUNTS(mt)");
        s.executeUpdate("CREATE INDEX kb_mt_gaf_top_level_term_counts_term_index ON MT_GAF_TOP_LEVEL_TERM_COUNTS(term)");
        PreparedStatement ps = s.getConnection().prepareStatement("insert into MT_GAF_TOP_LEVEL_TERM_COUNTS VALUES (?, ?, ?, ?)");
        int numberOfRows = 10000;
        for (int i = 1; i <= numberOfRows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            ps.setInt(4, i);
            ps.executeUpdate();
        }
        this.deleteRows(false, false);
        this.deleteRows(false, true);
        this.deleteRows(true, false);
        this.deleteRows(true, true);
        this.dropTable(DERBY_6045_DATA_TABLE2);
        ps.close();
        s.close();
    }

    void deleteRows(boolean runUpdateStatistics, boolean useParameterMarkers) throws SQLException {
        PreparedStatement ps;
        Statement s = this.createStatement();
        if (runUpdateStatistics) {
            s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'MT_GAF_TOP_LEVEL_TERM_COUNTS', null)");
        }
        if (useParameterMarkers) {
            ps = this.prepareStatement("DELETE FROM MT_GAF_TOP_LEVEL_TERM_COUNTS WHERE (term = ?) ");
            ps.setInt(1, 1);
            ps.execute();
        } else {
            s.execute("DELETE FROM MT_GAF_TOP_LEVEL_TERM_COUNTS WHERE (term = 2) ");
        }
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        InListMultiProbeTest.assertTrue((boolean)rtsp.usedIndexScan());
        if (useParameterMarkers) {
            ps = this.prepareStatement("DELETE FROM mt_gaf_top_level_term_counts WHERE (term = ?) OR (mt = ?)");
            ps.setInt(1, 3);
            ps.setInt(2, 4);
            ps.execute();
        } else {
            s.execute("DELETE FROM mt_gaf_top_level_term_counts WHERE (term = 5) OR (mt = 6)");
        }
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        InListMultiProbeTest.assertTrue((boolean)rtsp.usedIndexScan());
    }

    public void testMultiProbing() throws Exception {
        int size;
        this.readAllRows(this.createStatement());
        ArrayList<QueryStrategy> strategies = new ArrayList<QueryStrategy>();
        Random ran = new Random(2L);
        Connection c = this.getConnection();
        strategies.add(new MarkersStrategy(this, c, ran));
        strategies.add(new LiteralsStrategy(this, c, ran));
        strategies.add(new MixedIdsStrategy(this, c, ran));
        Statement st = this.createStatement();
        st.execute(RUNTIME_STATS_ON_QUERY);
        for (size = 2; size <= 10; size += 2) {
            this.testOneSize(strategies, size);
        }
        for (size = 20; size <= 100; size += 20) {
            this.testOneSize(strategies, size);
        }
        for (size = 200; size <= 1000; size += 200) {
            this.testOneSize(strategies, size);
        }
        strategies.remove(2);
        strategies.remove(1);
        for (size = 1250; size <= 2500; size += 250) {
            this.testOneSize(strategies, size);
        }
        st.execute(RUNTIME_STATS_OFF_QUERY);
        st.close();
        c = null;
    }

    public void testMultipleStartStopPreds() throws Exception {
        Statement st = this.createStatement();
        st.execute("create table ct (i int, c1 char(5), c2 char(10))");
        st.execute("insert into ct(i) values 1, 2, 3, 4, 5, 6, 7, 8, 9");
        st.execute("insert into ct(i) values 0, 10, 11, 12, 13, 14, 15");
        st.execute("insert into ct(i) values 16, 17, 18, 19");
        st.execute("insert into ct(i) select 7 * i from ct");
        st.execute("insert into ct(i) select 13 * i from ct");
        st.execute("update ct set c1 = cast(i as char(25))");
        st.execute("update ct set c2 = c1 || c1");
        st.execute("insert into ct values (91, '91', '1234')");
        st.execute("insert into ct values (91, '91', '212398')");
        st.execute("create index idx2 on ct (c1, c2)");
        String[][] expRS = new String[][]{{"1", "1    ", "1    1    "}, {"2", "2    ", "2    2    "}};
        st.execute(RUNTIME_STATS_ON_QUERY);
        PreparedStatement ps = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like '%'");
        ps.setString(1, "1");
        ps.setString(2, "2");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        ps = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2','1') and c2 like '%'");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        ps = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like ? order by i");
        ps.setString(1, "1");
        ps.setString(2, "2");
        ps.setString(3, "%");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        ps = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like ?");
        ps.setString(1, "1");
        ps.setString(2, "2");
        ps.setString(3, "%");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        ps = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2','1') and c2 like ?");
        ps.setString(1, "%");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        ps = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2',?) and c2 like ?");
        ps.setString(1, "1");
        ps.setString(2, "%");
        this.assertResultsAndQueryPlan(ps.executeQuery(), expRS, st);
        this.assertResultsAndQueryPlan(st.executeQuery("select i,c1,c2 from ct where c1 in ('1','2') and c2 like '%' order by i"), expRS, st);
        this.assertResultsAndQueryPlan(st.executeQuery("select i,c1,c2 from ct where c1 in ('1','2') and c2 >= '_' order by i"), null, st);
        this.assertResultsAndQueryPlan(st.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '_' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "212398    "}, {"91", "91   ", "1234      "}}, st);
        this.assertResultsAndQueryPlan(st.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '9' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "212398    "}, {"91", "91   ", "1234      "}}, st);
        this.assertResultsAndQueryPlan(st.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '9' and c2 > '13' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "212398    "}}, st);
        st.execute("drop table ct");
        st.execute("create table mytable (id int primary key)");
        st.execute("insert into mytable (id) values 0, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        st.execute("insert into mytable select id + 10 from mytable");
        st.execute("insert into mytable select id + 20 from mytable");
        st.execute("insert into mytable select id + 40 from mytable");
        st.execute("insert into mytable select id + 100 from mytable");
        JDBC.assertDrainResults(st.executeQuery("select mytable.id from mytable where mytable.id < 100"), 80);
        JDBC.assertUnorderedResultSet(st.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 )"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertUnorderedResultSet(st.executeQuery("select mytable.id from mytable where mytable.id < 100 and mytable.id in ( 2, 15, 19, 20, 21, 48, 49 )"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertUnorderedResultSet(st.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id < 100"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertEmpty(st.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id = 100"));
        JDBC.assertUnorderedResultSet(st.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id = 21"), new String[][]{{"21"}});
        st.execute(RUNTIME_STATS_OFF_QUERY);
        st.execute("drop table mytable");
        ps.close();
        st.close();
    }

    public void testProbePredPushedIntoSelectThenReverted() throws Exception {
        Statement st = this.createStatement();
        st.execute("create table d3253 (i int, vc varchar(10))");
        st.execute("insert into d3253 values (1, 'one'), (2, 'two'), (3, 'three'), (1, 'un')");
        JDBC.assertUnorderedResultSet(st.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.vc in ('un', 'trois')"), new String[][]{{"1", "un"}, {"1", "un"}});
        JDBC.assertUnorderedResultSet(st.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.i in (2, 3)"), new String[][]{{"2", "two"}, {"3", "three"}});
        JDBC.assertEmpty(st.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.vc in ('uno', 'tres')"));
        st.execute("drop table d3253");
        st.close();
    }

    public void testInListProbingWithOrderBy() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table CHEESE (CHEESE_CODE VARCHAR(5), CHEESE_NAME VARCHAR(20), CHEESE_COST DECIMAL(7,4))");
        st.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC)");
        st.execute("INSERT INTO CHEESE (CHEESE_CODE, CHEESE_NAME, CHEESE_COST) VALUES ('00000', 'GOUDA', 001.1234), ('00000', 'EDAM', 002.1111), ('54321', 'EDAM', 008.5646), ('12345', 'GORGONZOLA', 888.2309), ('AAAAA', 'EDAM', 999.8888), ('54321', 'MUENSTER', 077.9545)");
        String[][] expRS1 = new String[][]{{"AAAAA", "EDAM", "999.8888"}, {"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}};
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC"), expRS1);
        String[][] expRS2 = new String[][]{{"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}, {"AAAAA", "EDAM", "999.8888"}};
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC, CHEESE_COST DESC"), expRS2);
        BitSet colsToCheck = new BitSet(6);
        colsToCheck.set(3);
        colsToCheck.set(4);
        colsToCheck.set(5);
        Object[][] expRS3 = new String[][]{{"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}};
        JDBC.assertPartialResultSet(st.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC, 6 DESC"), expRS3, colsToCheck);
        Object[][] expRS4 = new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}};
        JDBC.assertPartialResultSet(st.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 DESC, 6 DESC"), expRS4, colsToCheck);
        PreparedStatement ps = this.prepareStatement("SELECT * FROM CHEESE WHERE CHEESE_CODE IN (?,?,?) AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC");
        ps.setString(1, "00000");
        ps.setString(2, "AAAAA");
        ps.setString(3, "54321");
        JDBC.assertFullResultSet(ps.executeQuery(), expRS1);
        ps = this.prepareStatement("SELECT * FROM CHEESE WHERE CHEESE_CODE IN (?,?,?) AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC, CHEESE_COST DESC");
        ps.setString(1, "00000");
        ps.setString(2, "AAAAA");
        ps.setString(3, "54321");
        JDBC.assertFullResultSet(ps.executeQuery(), expRS2);
        ps = this.prepareStatement("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND C2.CHEESE_CODE IN (?,?) AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC, 6 DESC");
        ps.setString(1, "00000");
        ps.setString(2, "54321");
        JDBC.assertPartialResultSet(ps.executeQuery(), expRS3, colsToCheck);
        ps = this.prepareStatement("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND C2.CHEESE_CODE IN (?,?) AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 ASC, 6 ASC");
        ps.setString(1, "00000");
        ps.setString(2, "54321");
        JDBC.assertPartialResultSet(ps.executeQuery(), expRS4, colsToCheck);
        st.execute("drop index cheese_index");
        st.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC)");
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), expRS1);
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC"), expRS2);
        JDBC.assertPartialResultSet(st.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC"), expRS3, colsToCheck);
        JDBC.assertPartialResultSet(st.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 DESC"), expRS4, colsToCheck);
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_NAME='EDAM' OR CHEESE_NAME='ADAM') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_NAME='EDAM' OR CHEESE_NAME='ADAM') ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}});
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"00000", "GOUDA", "1.1234"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE ASC, CHEESE_NAME ASC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "GOUDA", "1.1234"}});
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') OR (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"AAAAA", "EDAM", "999.8888"}, {"54321", "MUENSTER", "77.9545"}, {"54321", "EDAM", "8.5646"}, {"00000", "GOUDA", "1.1234"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(st.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') OR (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE ASC, CHEESE_NAME ASC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "GOUDA", "1.1234"}, {"54321", "EDAM", "8.5646"}, {"54321", "MUENSTER", "77.9545"}, {"AAAAA", "EDAM", "999.8888"}});
        ps.close();
        st.execute("drop table cheese");
        st.close();
    }

    public void testDerby6045WithUpdateStatistics() throws SQLException {
        this.helperDerby6045(10, true, false);
        this.helperDerby6045(24, true, false);
        this.helperDerby6045(10000, true, false);
    }

    public void testDerby6045WithoutUpdateStatistics() throws SQLException {
        this.helperDerby6045(10, false, false);
        this.helperDerby6045(24, false, false);
        this.helperDerby6045(10000, false, false);
    }

    public void testDerby6045WithUpdateStatisticsAndParams() throws SQLException {
        this.helperDerby6045(10, true, true);
        this.helperDerby6045(24, true, true);
        this.helperDerby6045(10000, true, true);
    }

    public void testDerby6045WithoutUpdateStatisticsAndWithParams() throws SQLException {
        this.helperDerby6045(10, false, true);
        this.helperDerby6045(24, false, true);
        this.helperDerby6045(10000, false, true);
    }

    public void helperDerby6045(int numberOfRows, boolean updateStatistics, boolean useParameterMarkers) throws SQLException {
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        s.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        s.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        PreparedStatement ps = s.getConnection().prepareStatement("insert into VARIABLE_TERM VALUES (?, '?var0', 1)");
        for (int i = 1; i <= numberOfRows; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        if (updateStatistics) {
            s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        }
        this.runThreeQueries(0, useParameterMarkers);
        this.dropTable(DERBY_6045_DATA_TABLE);
        ps.close();
        s.close();
    }

    public void testDerby6045() throws SQLException {
        int i;
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        s.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        s.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        PreparedStatement ps = s.getConnection().prepareStatement("insert into VARIABLE_TERM VALUES (?, '?var0', 1)");
        for (i = 1; i <= 10; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.runThreeQueries(0, false);
        for (i = 11; i <= 25; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(1, false);
        for (i = 26; i <= 10000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.runThreeQueries(2, false);
        s.close();
    }

    public void testDerby6045InsertAllRowsAdditionalUniqueIndex() throws SQLException {
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        s.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        s.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        s.executeUpdate("ALTER TABLE  VARIABLE_TERM ADD CONSTRAINT kb_variable_term_variable_name_unique  UNIQUE (var_name, var_type)");
        for (int i = 1; i <= 10000; ++i) {
            s.executeUpdate("insert into VARIABLE_TERM VALUES (" + i + ", '?var" + i + "'," + (i % 2 == 0 ? 1 : 4) + ")");
        }
        s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(0, false);
        s.close();
    }

    public void testDerby6045InsertAllRows() throws SQLException {
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        s.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        s.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        for (int i = 1; i <= 10000; ++i) {
            s.executeUpdate("insert into VARIABLE_TERM VALUES (" + i + ", '?var" + i + "'," + (i % 2 == 0 ? 1 : 4) + ")");
        }
        s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(0, false);
        s.close();
    }

    private void runThreeQueries(int numOfWhiteSpace, boolean useParameterMarkers) throws SQLException {
        PreparedStatement ps;
        Statement s = this.createStatement();
        Object whiteSpace = "";
        for (int i = 1; i <= numOfWhiteSpace; ++i) {
            whiteSpace = (String)whiteSpace + " ";
        }
        if (useParameterMarkers) {
            ps = this.prepareStatement("SELECT * FROM " + (String)whiteSpace + "VARIABLE_TERM WHERE TERM_ID = ?");
            ps.setInt(1, 11);
            JDBC.assertDrainResults(ps.executeQuery());
        } else {
            s.executeQuery("SELECT * FROM " + (String)whiteSpace + "VARIABLE_TERM WHERE TERM_ID = 11");
        }
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        InListMultiProbeTest.assertTrue((boolean)rtsp.usedIndexScan());
        if (useParameterMarkers) {
            ps = this.prepareStatement("SELECT * FROM " + (String)whiteSpace + "VARIABLE_TERM WHERE (TERM_ID = ?) OR (TERM_ID = ?) OR (TERM_ID = ?)");
            ps.setInt(1, 11);
            ps.setInt(2, 21);
            ps.setInt(3, 31);
            JDBC.assertDrainResults(ps.executeQuery());
        } else {
            s.executeQuery("SELECT  *  FROM  " + (String)whiteSpace + "VARIABLE_TERM WHERE (TERM_ID = 11) OR (TERM_ID =21) OR (TERM_ID = 31)");
        }
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        InListMultiProbeTest.assertTrue((boolean)rtsp.usedIndexScan());
        if (useParameterMarkers) {
            ps = this.prepareStatement("SELECT * FROM " + (String)whiteSpace + "VARIABLE_TERM WHERE (TERM_ID IN (?, ?, ?))");
            ps.setInt(1, 11);
            ps.setInt(2, 21);
            ps.setInt(3, 31);
            JDBC.assertDrainResults(ps.executeQuery());
        } else {
            s.executeQuery("SELECT  *  FROM " + (String)whiteSpace + "VARIABLE_TERM WHERE (TERM_ID IN (11, 21, 31))");
        }
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        InListMultiProbeTest.assertTrue((boolean)rtsp.usedIndexScan());
        s.close();
    }

    public void testDerby3603() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"2"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d3603_a.a_id from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"1"}, {"3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d3603_a.a_id,d3603_c.d_id        from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"1", "1"}, {"3", "1"}});
    }

    public void testDerby4376() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table d4376(x int primary key)");
        s.execute("insert into d4376 values (1), (2), (3)");
        PreparedStatement ps = this.prepareStatement("select * from d4376 where x in (?, ?)");
        ps.setNull(1, 4);
        ps.setInt(2, 1);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        s.execute("drop table d4376");
    }

    public void testDuplicateParameters() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d4378(x int primary key, y int)");
        s.execute("insert into d4378 values (1,2),(3,4),(5,6),(7,8),(9,10)");
        s.execute("insert into d4378 select y, x from d4378");
        PreparedStatement ps = this.prepareStatement("select * from d4378 where x in (?,?,?)");
        ps.setInt(1, 1);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"1", "2"}});
        this.rollback();
    }

    private static void insertNDataRows(Connection conn, int numRows, Random random) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("insert into CHANGES (KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID) VALUES (?, ?, ?, ?, ?, ?, ?)");
        String foreignKey = null;
        int numRowsInGroup = 0;
        while (numRows-- > 0) {
            if (numRowsInGroup <= 0) {
                numRowsInGroup = (int)(1.5 + Math.abs(2.0 * random.nextGaussian()));
                foreignKey = InListMultiProbeTest.genUUIDValue(random);
            }
            DataRow dr = new DataRow(random, foreignKey);
            dr.setParameters(stmt);
            stmt.addBatch();
            --numRowsInGroup;
        }
        int[] results = stmt.executeBatch();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == 1) continue;
            InListMultiProbeTest.fail((String)"Failed to insert rows into CHANGES");
        }
        stmt.close();
    }

    private void testOneSize(List<QueryStrategy> strategies, int cnt) throws SQLException {
        if (cnt > this.allIds.length) {
            return;
        }
        String failedStrategy = null;
        Statement st = this.createStatement();
        for (QueryStrategy strategy : strategies) {
            int numRows = strategy.testSize(cnt);
            ResultSet rs = st.executeQuery(GET_RUNTIME_STATS_QUERY);
            if (!this.checkMultiProbeQueryPlan(rs, numRows)) {
                failedStrategy = strategy.getName();
                break;
            }
            rs.close();
        }
        st.close();
        if (failedStrategy != null) {
            InListMultiProbeTest.fail((String)("Execution of '" + failedStrategy + "' strategy with " + cnt + " id(s) should have resulted in index multi-probing, but did not."));
        }
    }

    private void readAllRows(Statement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery(SELECT_ALL);
        this.foreignIdToRowsMap = new TreeMap();
        while (rs.next()) {
            DataRow c = new DataRow(rs);
            List<DataRow> list = this.foreignIdToRowsMap.get(c.foreign_key_uuid);
            if (list == null) {
                list = new ArrayList<DataRow>();
                this.foreignIdToRowsMap.put(c.foreign_key_uuid, list);
            }
            list.add(c);
        }
        rs.close();
        stmt.close();
        this.allIds = new String[this.foreignIdToRowsMap.size()];
        this.foreignIdToRowsMap.keySet().toArray(this.allIds);
    }

    private static String genUUIDValue(Random random) {
        char[] chars = new char[23];
        chars[0] = 95;
        for (int ndx = 1; ndx < chars.length; ++ndx) {
            int offset = random.nextInt(uuid_chars.length);
            chars[ndx] = uuid_chars[offset];
        }
        return new String(chars);
    }

    private void assertResultsAndQueryPlan(ResultSet rs, String[][] expRS, Statement st) throws SQLException {
        int numRows = 0;
        if (expRS == null || expRS.length == 0) {
            JDBC.assertEmpty(rs);
        } else {
            JDBC.assertUnorderedResultSet(rs, expRS);
            numRows = expRS.length;
        }
        ResultSet statRS = st.executeQuery(GET_RUNTIME_STATS_QUERY);
        if (!this.checkMultiProbeQueryPlan(statRS, numRows)) {
            InListMultiProbeTest.fail((String)"Expected multi-probing index scan but query plan showed something else.");
        }
        statRS.close();
    }

    private boolean checkMultiProbeQueryPlan(ResultSet rStat, int expRowCount) throws SQLException {
        if (!rStat.next()) {
            return false;
        }
        RuntimeStatisticsParser rsp = new RuntimeStatisticsParser(rStat.getString(1));
        return rsp.usedIndexRowToBaseRow() && rsp.usedIndexScan() && rsp.rowsQualifiedEquals(expRowCount);
    }

    class MarkersStrategy
    extends QueryStrategy {
        public MarkersStrategy(InListMultiProbeTest this$0, Connection conn, Random random) {
            super(conn, random);
        }

        @Override
        protected String getName() {
            return "Markers";
        }

        @Override
        protected int fetchDataRows(String[] ids) throws SQLException {
            StringBuffer query = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            query.append("?");
            for (int i = 1; i < ids.length; ++i) {
                query.append(", ?");
            }
            query.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement stmt = this.conn.prepareStatement(query.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            int totalDataRows = this.validate(ids, stmt.executeQuery());
            stmt.close();
            return totalDataRows;
        }
    }

    class LiteralsStrategy
    extends QueryStrategy {
        public LiteralsStrategy(InListMultiProbeTest this$0, Connection conn, Random random) {
            super(conn, random);
        }

        @Override
        protected String getName() {
            return "Literals";
        }

        @Override
        protected int fetchDataRows(String[] ids) throws SQLException {
            StringBuffer query = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            query.append("'");
            query.append(ids[0]);
            query.append("'");
            for (int i = 1; i < ids.length; ++i) {
                query.append(", '");
                query.append(ids[i]);
                query.append("'");
            }
            query.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement stmt = this.conn.prepareStatement(query.toString());
            int totalDataRows = this.validate(ids, stmt.executeQuery());
            stmt.close();
            return totalDataRows;
        }
    }

    class MixedIdsStrategy
    extends QueryStrategy {
        public MixedIdsStrategy(InListMultiProbeTest this$0, Connection conn, Random random) {
            super(conn, random);
        }

        @Override
        protected String getName() {
            return "MixedIds";
        }

        @Override
        protected int fetchDataRows(String[] ids) throws SQLException {
            StringBuffer query = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            query.append("?");
            for (int i = 1; i < ids.length; ++i) {
                if (i % 2 == 1) {
                    query.append(", '");
                    query.append(ids[i]);
                    query.append("'");
                    continue;
                }
                query.append(", ?");
            }
            query.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement stmt = this.conn.prepareStatement(query.toString());
            int p = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (i % 2 != 0) continue;
                stmt.setString(++p, ids[i]);
            }
            int totalDataRows = this.validate(ids, stmt.executeQuery());
            stmt.close();
            return totalDataRows;
        }
    }

    private static class DataRow {
        static long nextId = 1L;
        final String kind;
        final String item_uuid;
        final String item_type;
        final String before;
        final String after;
        final String foreign_key_uuid;
        final long id;

        DataRow(Random random, String foreignKey) {
            int kindChoice = random.nextInt(3);
            switch (kindChoice) {
                case 0: {
                    this.kind = "ADD";
                    break;
                }
                case 1: {
                    this.kind = "MOD";
                    break;
                }
                default: {
                    this.kind = "DEL";
                }
            }
            this.item_uuid = InListMultiProbeTest.genUUIDValue(random);
            this.item_type = random.nextBoolean() ? "http://companyA.com/divB/x.y.z/packageC#typeD" : "http://companyE.com/divF/i.j.k/packageG#typeH";
            this.before = InListMultiProbeTest.genUUIDValue(random);
            this.after = InListMultiProbeTest.genUUIDValue(random);
            this.foreign_key_uuid = foreignKey;
            this.id = nextId++;
        }

        DataRow(ResultSet rs) throws SQLException {
            this.kind = rs.getString(1);
            this.item_uuid = rs.getString(2);
            this.item_type = rs.getString(3);
            this.before = rs.getString(4);
            this.after = rs.getString(5);
            this.foreign_key_uuid = rs.getString(6);
            this.id = rs.getLong(7);
        }

        void setParameters(PreparedStatement ps) throws SQLException {
            ps.setString(1, this.kind);
            ps.setString(2, this.item_uuid);
            ps.setString(3, this.item_type);
            ps.setString(4, this.before);
            ps.setString(5, this.after);
            ps.setString(6, this.foreign_key_uuid);
            ps.setLong(7, this.id);
        }

        String[] getColumns() {
            return new String[]{this.kind, this.item_uuid, this.item_type, this.before, this.after, this.foreign_key_uuid, Long.toString(this.id)};
        }
    }

    abstract class QueryStrategy {
        private Random random;
        protected Connection conn;
        Comparator<String[]> rowComparator = new Comparator<String[]>(this){

            @Override
            public int compare(String[] o1, String[] o2) {
                Long id1 = Long.valueOf(o1[6]);
                Long id2 = Long.valueOf(o2[6]);
                return id1.compareTo(id2);
            }
        };

        public QueryStrategy(Connection conn, Random random) {
            this.conn = conn;
            this.random = random;
        }

        public final int testSize(int size) throws SQLException {
            HashSet<String> s = new HashSet<String>();
            while (s.size() < size) {
                int index = this.random.nextInt(InListMultiProbeTest.this.allIds.length);
                s.add(InListMultiProbeTest.this.allIds[index]);
            }
            String[] ids = new String[size];
            s.toArray(ids);
            return this.fetchDataRows(ids);
        }

        protected int validate(String[] foreignIds, ResultSet results) throws SQLException {
            ArrayList<String[]> expected = new ArrayList<String[]>(InListMultiProbeTest.this.foreignIdToRowsMap.size());
            for (int i = 0; i < foreignIds.length; ++i) {
                List<DataRow> list = InListMultiProbeTest.this.foreignIdToRowsMap.get(foreignIds[i]);
                for (int j = list.size() - 1; j >= 0; --j) {
                    expected.add(list.get(j).getColumns());
                }
            }
            Collections.sort(expected, this.rowComparator);
            Object[] expArray = expected.toArray();
            String[][] expRS = new String[expArray.length][];
            for (int i = 0; i < expArray.length; ++i) {
                expRS[i] = (String[])expArray[i];
            }
            JDBC.assertFullResultSet(results, expRS);
            return expRS.length;
        }

        protected abstract int fetchDataRows(String[] var1) throws SQLException;

        protected abstract String getName();
    }
}

