package org.apache.torque.templates.transformer.om;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;

/**
 * Transforms an Inheritance element.
 */
public class OMInheritanceTransformer
{
    public void transform(
            SourceElement inheritanceElement,
            ControllerState controllerState)
                    throws SourceTransformerException
    {
        if (!TorqueSchemaElementName.INHERITANCE.getName().equals(
                inheritanceElement.getName()))
        {
            throw new IllegalArgumentException("Illegal element Name "
                    + inheritanceElement.getName());
        }
        String key = (String)
                inheritanceElement.getAttribute(TorqueSchemaAttributeName.KEY);
        if (key == null)
        {
            throw new IllegalArgumentException(
                    "Attribute \""
                            + TorqueSchemaAttributeName.KEY
                            + "\" not set in Element "
                            + TorqueSchemaElementName.INHERITANCE);
        }
        inheritanceElement.setAttribute(
                InheritanceAttributeName.CLASSKEY_CONSTANT,
                "CLASSKEY_" + key.toUpperCase());

        SourceElement tableElement
        = inheritanceElement.getParent().getParent();
        String className = (String) inheritanceElement.getAttribute(
                TorqueSchemaAttributeName.CLASS.getName());
        if (className == null)
        {
            className = (String) tableElement.getAttribute(
                    TableAttributeName.DB_OBJECT_CLASS_NAME);
        }
        inheritanceElement.setAttribute(
                InheritanceAttributeName.CLASS_NAME, className);
        inheritanceElement.setAttribute(
                InheritanceAttributeName.PACKAGE,
                tableElement.getAttribute(
                        TableAttributeName.DB_OBJECT_PACKAGE));
        {
            String extendsAttribute = (String) inheritanceElement.getAttribute(
                    TorqueSchemaAttributeName.EXTENDS.getName());
            String beanExtends = (String) inheritanceElement.getAttribute(
                    InheritanceAttributeName.BEAN_EXTENDS);
            if (extendsAttribute == null)
            {
                extendsAttribute = (String) tableElement.getAttribute(
                        TableAttributeName.DB_OBJECT_CLASS_NAME);
                inheritanceElement.setAttribute(
                        TorqueSchemaAttributeName.EXTENDS.getName(),
                        extendsAttribute);
                inheritanceElement.setAttribute(
                        InheritanceAttributeName.BEAN_EXTENDS,
                        tableElement.getAttribute(
                                TableAttributeName.BEAN_CLASS_NAME));
            }
            else if (beanExtends == null)
            {
                // we try to guess the extendsBean from extends
                // and the bean package
                int lastDot = extendsAttribute.lastIndexOf(".");
                String unqualifiedClassname;
                if (lastDot != -1)
                {
                    unqualifiedClassname
                    = extendsAttribute.substring(lastDot + 1);
                }
                else
                {
                    unqualifiedClassname = extendsAttribute;
                }
                beanExtends = controllerState.getOption(
                        "torque.om.className.beanClassNamePrefix")
                        + unqualifiedClassname
                        + controllerState.getOption(
                                "torque.om.className.beanClassNameSuffix");
                inheritanceElement.setAttribute(
                        InheritanceAttributeName.BEAN_EXTENDS,
                        beanExtends);
            }
        }
        {
            int lastDot = className.lastIndexOf(".");
            String unqualifiedClassname;
            if (lastDot != -1)
            {
                unqualifiedClassname
                = className.substring(lastDot + 1);
            }
            else
            {
                unqualifiedClassname = className;
            }
            String beanClassName = controllerState.getOption(
                    "torque.om.className.beanClassNamePrefix")
                    + unqualifiedClassname
                    + controllerState.getOption(
                            "torque.om.className.beanClassNameSuffix");
            inheritanceElement.setAttribute(
                    InheritanceAttributeName.BEAN_CLASS_NAME,
                    beanClassName);

        }
        inheritanceElement.setAttribute(
                InheritanceAttributeName.BEAN_PACKAGE,
                tableElement.getAttribute(
                        TableAttributeName.BEAN_PACKAGE));
    }
}
