/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.entitymanager;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.jpa.api.entitymanager.EntityManagerResolver;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerMetadata;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerRef;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;

@ApplicationScoped
public class EntityManagerRefLookup {
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;
    private volatile Boolean globalEntityManagerInitialized;
    private boolean globalEntityManagerIsNormalScope;
    private EntityManager globalEntityManager;

    private void lazyInitGlobalEntityManager() {
        if (this.globalEntityManagerInitialized == null) {
            this.initGlobalEntityManager();
        }
    }

    private synchronized void initGlobalEntityManager() {
        if (this.globalEntityManagerInitialized == null) {
            Set beans;
            BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
            Bean bean = beanManager.resolve(beans = beanManager.getBeans(EntityManager.class, new Annotation[0]));
            if (bean == null) {
                throw new IllegalStateException("Could not find EntityManager with default qualifier.");
            }
            this.globalEntityManagerIsNormalScope = beanManager.isNormalScope(bean.getScope());
            if (this.globalEntityManagerIsNormalScope) {
                this.globalEntityManager = (EntityManager)beanManager.getReference(bean, EntityManager.class, beanManager.createCreationalContext((Contextual)bean));
            }
            this.globalEntityManagerInitialized = true;
        }
    }

    public EntityManagerRef lookupReference(EntityManagerMetadata entityManagerMetadata) {
        EntityManagerRef ref = new EntityManagerRef();
        EntityManagerResolver unmanagedResolver = entityManagerMetadata.getUnmanagedResolver();
        if (unmanagedResolver != null) {
            ref.setEntityManagerResolver(unmanagedResolver);
            ref.setEntityManager(unmanagedResolver.resolveEntityManager());
        } else if (entityManagerMetadata.getEntityManagerResolverClass() != null) {
            ref.setEntityManagerResolverClass(entityManagerMetadata.getEntityManagerResolverClass());
            if (entityManagerMetadata.isEntityManagerResolverIsNormalScope()) {
                ref.setEntityManagerResolver((EntityManagerResolver)BeanProvider.getContextualReference(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
            } else {
                ref.setEntityManagerResolverDependentProvider((DependentProvider<? extends EntityManagerResolver>)BeanProvider.getDependent(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
                ref.setEntityManagerResolver((EntityManagerResolver)ref.getEntityManagerResolverDependentProvider().get());
            }
            ref.setEntityManager(ref.getEntityManagerResolver().resolveEntityManager());
        } else {
            if (this.activeEntityManagerHolder.isSet()) {
                ref.setEntityManager(this.activeEntityManagerHolder.get());
                return ref;
            }
            this.lazyInitGlobalEntityManager();
            if (this.globalEntityManagerIsNormalScope) {
                ref.setEntityManager(this.globalEntityManager);
            } else {
                ref.setEntityManagerDependentProvider((DependentProvider<? extends EntityManager>)BeanProvider.getDependent(EntityManager.class, (Annotation[])new Annotation[0]));
                ref.setEntityManager((EntityManager)ref.getEntityManagerDependentProvider().get());
            }
        }
        if (entityManagerMetadata.getEntityManagerFlushMode() != null) {
            ref.getEntityManager().setFlushMode(entityManagerMetadata.getEntityManagerFlushMode());
        }
        return ref;
    }
}

