/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;

public final class NameFormHelper {
    private NameFormHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(NameForm nameForm, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                nameForm.unlock();
                AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
                ObjectClass structuralObjectClass = (ObjectClass)registries.getObjectClassRegistry().lookup(nameForm.getStructuralObjectClassOid());
                nameForm.setStructuralObjectClass(structuralObjectClass);
                nameForm.getMayAttributeTypes().clear();
                for (String oid : nameForm.getMayAttributeTypeOids()) {
                    nameForm.getMayAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                }
                nameForm.getMustAttributeTypes().clear();
                for (String oid : nameForm.getMustAttributeTypeOids()) {
                    nameForm.getMustAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                }
            }
            finally {
                nameForm.lock();
            }
        }
    }
}

