/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.cli;

import java.io.Serializable;
import java.util.Vector;
import org.apache.directory.fortress.core.cli.CmdLineParser;
import org.apache.directory.fortress.core.model.Address;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CmdLineParser parser;
    private final CmdLineParser.Option userId;
    private final CmdLineParser.Option password;
    private final CmdLineParser.Option newPassword;
    private final CmdLineParser.Option ou;
    private final CmdLineParser.Option pwPolicy;
    private final CmdLineParser.Option cn;
    private final CmdLineParser.Option sn;
    private final CmdLineParser.Option description;
    private final CmdLineParser.Option title;
    private final CmdLineParser.Option employeeType;
    private final CmdLineParser.Option beginTime;
    private final CmdLineParser.Option endTime;
    private final CmdLineParser.Option beginDate;
    private final CmdLineParser.Option endDate;
    private final CmdLineParser.Option beginLockDate;
    private final CmdLineParser.Option endLockDate;
    private final CmdLineParser.Option dayMask;
    private final CmdLineParser.Option name;
    private final CmdLineParser.Option timeout;
    private final CmdLineParser.Option properties;
    private final CmdLineParser.Option roleAssigns;
    private final CmdLineParser.Option role;
    private final CmdLineParser.Option adminRoleAssigns;
    private final CmdLineParser.Option type;
    private final CmdLineParser.Option opName;
    private final CmdLineParser.Option ascendant;
    private final CmdLineParser.Option descendant;
    private final CmdLineParser.Option cardinality;
    private final CmdLineParser.Option osPs;
    private final CmdLineParser.Option osUs;
    private final CmdLineParser.Option beginRange;
    private final CmdLineParser.Option endRange;
    private final CmdLineParser.Option beginInclusive;
    private final CmdLineParser.Option endInclusive;
    private final CmdLineParser.Option phones;
    private final CmdLineParser.Option mobiles;
    private final CmdLineParser.Option emails;
    private final CmdLineParser.Option address;
    private final CmdLineParser.Option state;
    private final CmdLineParser.Option city;
    private final CmdLineParser.Option postalCode;
    private final CmdLineParser.Option postalOfficeBox;
    private final CmdLineParser.Option protocol;
    private final CmdLineParser.Option member;

    public Options(CmdLineParser parser) {
        this.parser = parser;
        this.userId = parser.addStringOption('u', "userId");
        this.password = parser.addStringOption('p', "password");
        this.newPassword = parser.addStringOption('V', "newpassword");
        this.ou = parser.addStringOption('o', "orgUnit");
        this.pwPolicy = parser.addStringOption('w', "pwPolicy");
        this.cn = parser.addStringOption('c', "cn");
        this.sn = parser.addStringOption('s', "sn");
        this.description = parser.addStringOption('d', "description");
        this.beginTime = parser.addStringOption('b', "beginTime");
        this.endTime = parser.addStringOption('e', "endTime");
        this.beginDate = parser.addStringOption('B', "beginDate");
        this.endDate = parser.addStringOption('E', "endDate");
        this.beginLockDate = parser.addStringOption('l', "beginLockDate");
        this.endLockDate = parser.addStringOption('N', "endLockDate");
        this.dayMask = parser.addStringOption('m', "dayMask");
        this.name = parser.addStringOption('n', "name");
        this.timeout = parser.addStringOption('t', "timeout");
        this.properties = parser.addStringOption('v', "properties");
        this.roleAssigns = parser.addStringOption('r', "roles");
        this.role = parser.addStringOption('R', "role");
        this.adminRoleAssigns = parser.addStringOption('a', "adminRoles");
        this.type = parser.addStringOption('T', "type");
        this.opName = parser.addStringOption('O', "opName");
        this.ascendant = parser.addStringOption('A', "ascendant");
        this.descendant = parser.addStringOption('D', "descendant");
        this.cardinality = parser.addStringOption('C', "cardinality");
        this.osPs = parser.addStringOption('P', "osPs");
        this.osUs = parser.addStringOption('U', "osUs");
        this.beginRange = parser.addStringOption('x', "beginRange");
        this.endRange = parser.addStringOption('w', "endRange");
        this.beginInclusive = parser.addStringOption('y', "beginInclusive");
        this.endInclusive = parser.addStringOption('z', "endInclusive");
        this.phones = parser.addStringOption('y', "phones");
        this.mobiles = parser.addStringOption('Y', "mobiles");
        this.emails = parser.addStringOption('@', "emails");
        this.address = parser.addStringOption('>', "address");
        this.state = parser.addStringOption('<', "state");
        this.city = parser.addStringOption('3', "city");
        this.postalCode = parser.addStringOption('z', "postalCode");
        this.postalOfficeBox = parser.addStringOption('2', "postalOfficeBox");
        this.title = parser.addStringOption('3', "title");
        this.employeeType = parser.addStringOption('4', "employeeType");
        this.protocol = parser.addStringOption('X', "protocol");
        this.member = parser.addStringOption('M', "member");
    }

    public SDSet getSdSet() {
        SDSet sdSet = new SDSet();
        sdSet.setName(this.getName());
        sdSet.setDescription(this.getDescription());
        this.updateRoleAssigns(sdSet);
        try {
            Integer cardinality = Integer.valueOf(this.getCardinality());
            sdSet.setCardinality(cardinality);
        }
        catch (NumberFormatException ne) {
            sdSet.setCardinality(2);
        }
        return sdSet;
    }

    public OrgUnit getOrgUnit() {
        OrgUnit orgUnit = new OrgUnit();
        orgUnit.setName(this.getName());
        orgUnit.setDescription(this.getDescription());
        return orgUnit;
    }

    public Group getGroup() {
        Group group = new Group();
        group.setName(this.getName());
        group.setDescription(this.getDescription());
        group.setProtocol(this.getProtocol());
        this.updateAssigns(group);
        this.updateProperties(group);
        return group;
    }

    public Role getRole() {
        Role role = new Role();
        role.setDescription(this.getDescription());
        this.updateTemporal(role);
        return role;
    }

    public AdminRole getAdminRole() {
        AdminRole role = new AdminRole();
        role.setDescription(this.getDescription());
        role.setBeginRange(this.getBeginRange());
        role.setEndRange(this.getEndRange());
        Boolean bVal = Boolean.valueOf(this.getBeginInclusive());
        role.setBeginInclusive(bVal);
        bVal = Boolean.valueOf(this.getEndInclusive());
        role.setEndInclusive(bVal);
        this.updateOsPs(role);
        this.updateOsUs(role);
        this.updateTemporal(role);
        return role;
    }

    public Relationship getRelationship() {
        Relationship relationship = new Relationship();
        relationship.setChild(this.getDescendant());
        relationship.setParent(this.getAscendant());
        return relationship;
    }

    public PermObj getPermObj() {
        PermObj permObj = new PermObj();
        permObj.setObjName(this.getName());
        permObj.setDescription(this.getDescription());
        permObj.setOu(this.getOu());
        permObj.setType(this.getType());
        this.updateProperties(permObj);
        return permObj;
    }

    public Permission getPermission() {
        Permission perm = new Permission();
        perm.setObjName(this.getName());
        perm.setOpName(this.getOpName());
        this.updateRoleAssigns(perm);
        this.updateProperties(perm);
        perm.setType(this.getType());
        return perm;
    }

    public User getUser() {
        User user = new User();
        user.setUserId(this.getUserId());
        user.setPassword(this.getPassword());
        user.setOu(this.getOu());
        user.setPwPolicy(this.getPwPolicy());
        user.setCn(this.getCn());
        user.setSn(this.getSn());
        user.setDescription(this.getDescription());
        user.setTitle(this.getTitle());
        user.setEmployeeType(this.getEmployeeType());
        this.updateTemporal(user);
        this.updateProperties(user);
        this.updateRoleAssigns(user);
        this.updateAdminRoleAssigns(user);
        this.updatePhones(user);
        this.updateMobiles(user);
        this.updateEmails(user);
        this.updateAddress(user);
        return user;
    }

    private void updateTemporal(Constraint constraint) {
        constraint.setBeginTime(this.getBeginTime());
        constraint.setEndTime(this.getEndTime());
        constraint.setBeginDate(this.getBeginDate());
        constraint.setEndDate(this.getEndDate());
        constraint.setBeginLockDate(this.getBeginLockDate());
        constraint.setEndLockDate(this.getEndLockDate());
        constraint.setDayMask(this.getDayMask());
        constraint.setName(this.getName());
        try {
            Integer to = Integer.valueOf(this.getTimeout());
            constraint.setTimeout(to);
        }
        catch (NumberFormatException ne) {
            constraint.setTimeout(0);
        }
    }

    public String getUserId() {
        return (String)this.parser.getOptionValue(this.userId);
    }

    public String getPassword() {
        return (String)this.parser.getOptionValue(this.password);
    }

    public String getNewPassword() {
        return (String)this.parser.getOptionValue(this.newPassword);
    }

    private void updateProperties(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.properties);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                int indx = szRaw.indexOf(58);
                if (indx < 1) continue;
                user.addProperty(szRaw.substring(0, indx), szRaw.substring(indx + 1));
            }
        }
    }

    private void updateProperties(PermObj permObj) {
        Vector fractionValues = this.parser.getOptionValues(this.properties);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                int indx = szRaw.indexOf(58);
                if (indx < 1) continue;
                permObj.addProperty(szRaw.substring(0, indx), szRaw.substring(indx + 1));
            }
        }
    }

    private void updateProperties(Permission perm) {
        Vector fractionValues = this.parser.getOptionValues(this.properties);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                int indx = szRaw.indexOf(58);
                if (indx < 1) continue;
                perm.addProperty(szRaw.substring(0, indx), szRaw.substring(indx + 1));
            }
        }
    }

    private void updateProperties(Group group) {
        Vector fractionValues = this.parser.getOptionValues(this.properties);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                int indx = szRaw.indexOf(61);
                if (indx < 1) continue;
                group.addProperty(szRaw.substring(0, indx), szRaw.substring(indx + 1));
            }
        }
    }

    private void updateAssigns(Group group) {
        Vector fractionValues = this.parser.getOptionValues(this.member);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                group.setMember(szRaw);
            }
        }
    }

    private void updateRoleAssigns(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.roleAssigns);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                user.setRoleName(szRaw);
            }
        }
    }

    private void updateRoleAssigns(Permission perm) {
        Vector fractionValues = this.parser.getOptionValues(this.roleAssigns);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                perm.setRole(szRaw);
            }
        }
    }

    private void updateAdminRoleAssigns(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.adminRoleAssigns);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                user.setAdminRoleName(szRaw);
            }
        }
    }

    private void updateRoleAssigns(SDSet sdSet) {
        Vector fractionValues = this.parser.getOptionValues(this.roleAssigns);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                sdSet.addMember(szRaw);
            }
        }
    }

    private void updateOsPs(AdminRole role) {
        Vector fractionValues = this.parser.getOptionValues(this.osPs);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                role.setOsP(szRaw);
            }
        }
    }

    private void updateOsUs(AdminRole role) {
        Vector fractionValues = this.parser.getOptionValues(this.osPs);
        if (fractionValues != null) {
            for (Object raw : fractionValues) {
                String szRaw = (String)raw;
                role.setOsU(szRaw);
            }
        }
    }

    private void updatePhones(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.phones);
        if (fractionValues != null) {
            for (Object val : fractionValues) {
                String number = (String)val;
                user.setPhone(number);
            }
        }
    }

    private void updateMobiles(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.mobiles);
        if (fractionValues != null) {
            for (Object val : fractionValues) {
                String number = (String)val;
                user.setMobile(number);
            }
        }
    }

    private void updateEmails(User user) {
        Vector fractionValues = this.parser.getOptionValues(this.emails);
        if (fractionValues != null) {
            for (Object val : fractionValues) {
                String email = (String)val;
                user.setPhone(email);
            }
        }
    }

    private void updateAddress(User user) {
        Address uAddr = user.getAddress();
        Vector fractionValues = this.parser.getOptionValues(this.address);
        if (fractionValues != null) {
            for (Object val : fractionValues) {
                String szAddress = (String)val;
                uAddr.setAddress(szAddress);
            }
        }
        uAddr.setCity(this.getCity());
        uAddr.setState(this.getState());
        uAddr.setPostalCode(this.getPostalCode());
        uAddr.setPostOfficeBox(this.getPostOfficeBox());
    }

    String getState() {
        return (String)this.parser.getOptionValue(this.state);
    }

    String getCity() {
        return (String)this.parser.getOptionValue(this.city);
    }

    String getPostalCode() {
        return (String)this.parser.getOptionValue(this.postalCode);
    }

    String getPostOfficeBox() {
        return (String)this.parser.getOptionValue(this.postalOfficeBox);
    }

    String getOu() {
        return (String)this.parser.getOptionValue(this.ou);
    }

    String getPwPolicy() {
        return (String)this.parser.getOptionValue(this.pwPolicy);
    }

    String getCn() {
        return (String)this.parser.getOptionValue(this.cn);
    }

    String getSn() {
        return (String)this.parser.getOptionValue(this.sn);
    }

    String getDescription() {
        return (String)this.parser.getOptionValue(this.description);
    }

    String getTitle() {
        return (String)this.parser.getOptionValue(this.title);
    }

    String getEmployeeType() {
        return (String)this.parser.getOptionValue(this.employeeType);
    }

    String getBeginTime() {
        return (String)this.parser.getOptionValue(this.beginTime);
    }

    String getEndTime() {
        return (String)this.parser.getOptionValue(this.endTime);
    }

    String getBeginDate() {
        return (String)this.parser.getOptionValue(this.beginDate);
    }

    String getEndDate() {
        return (String)this.parser.getOptionValue(this.endDate);
    }

    String getBeginLockDate() {
        return (String)this.parser.getOptionValue(this.beginLockDate);
    }

    String getEndLockDate() {
        return (String)this.parser.getOptionValue(this.endLockDate);
    }

    String getDayMask() {
        return (String)this.parser.getOptionValue(this.dayMask);
    }

    String getRoleNm() {
        return (String)this.parser.getOptionValue(this.role);
    }

    String getName() {
        return (String)this.parser.getOptionValue(this.name);
    }

    String getTimeout() {
        return (String)this.parser.getOptionValue(this.timeout);
    }

    String getType() {
        return (String)this.parser.getOptionValue(this.type);
    }

    String getOpName() {
        return (String)this.parser.getOptionValue(this.opName);
    }

    String getAscendant() {
        return (String)this.parser.getOptionValue(this.ascendant);
    }

    String getDescendant() {
        return (String)this.parser.getOptionValue(this.descendant);
    }

    String getCardinality() {
        return (String)this.parser.getOptionValue(this.cardinality);
    }

    String getBeginRange() {
        return (String)this.parser.getOptionValue(this.beginRange);
    }

    String getEndRange() {
        return (String)this.parser.getOptionValue(this.endRange);
    }

    String getBeginInclusive() {
        return (String)this.parser.getOptionValue(this.beginInclusive);
    }

    String getEndInclusive() {
        return (String)this.parser.getOptionValue(this.endInclusive);
    }

    String getProtocol() {
        return (String)this.parser.getOptionValue(this.protocol);
    }

    String getMember() {
        return (String)this.parser.getOptionValue(this.member);
    }
}

