/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.OrganizationalUnitDAO;
import org.apache.directory.fortress.core.model.OrganizationalUnit;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationalUnitP {
    private static final String CLS_NM = OrganizationalUnitP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    public final void add(OrganizationalUnit orgUnit) throws SecurityException {
        this.validate(orgUnit);
        OrganizationalUnitDAO oDao = new OrganizationalUnitDAO();
        oDao.create(orgUnit);
    }

    public final void delete(OrganizationalUnit orgUnit) throws SecurityException {
        OrganizationalUnitDAO oDao = new OrganizationalUnitDAO();
        oDao.remove(orgUnit);
    }

    private void validate(OrganizationalUnit entity) throws SecurityException {
        if (entity.getName().length() > 40) {
            String name = entity.getName();
            String error = "validate name [" + name + "] invalid length [" + entity.getName().length() + "]";
            LOG.warn(error);
            throw new ValidationException(6004, error);
        }
        if (StringUtils.isEmpty((String)entity.getName())) {
            String error = "validate name validation failed, null or empty value";
            LOG.warn(error);
            throw new ValidationException(6003, error);
        }
        if (entity.getParent() != null && entity.getParent().length() > 40) {
            String name = entity.getName();
            String error = "validate parent [" + name + "] invalid length [" + entity.getName().length() + "]";
            LOG.warn(error);
            throw new ValidationException(6006, error);
        }
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
    }
}

