/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.AdminRoleRelationship;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.OrgUnitRelationship;
import org.apache.directory.fortress.core.model.PermGrant;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public final class DelAdminMgrRestImpl
extends Manageable
implements DelAdminMgr {
    private static final String CLS_NM = DelAdminMgrRestImpl.class.getName();

    @Override
    public AdminRole addRole(AdminRole role) throws SecurityException {
        VUtil.assertNotNull(role, 9007, CLS_NM + ".addRole");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        AdminRole retRole = (AdminRole)response.getEntity();
        return retRole;
    }

    @Override
    public void deleteRole(AdminRole role) throws SecurityException {
        VUtil.assertNotNull(role, 9007, CLS_NM + ".deleteRole");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public AdminRole updateRole(AdminRole role) throws SecurityException {
        VUtil.assertNotNull(role, 9007, CLS_NM + ".updateRole");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        AdminRole retRole = (AdminRole)response.getEntity();
        return retRole;
    }

    @Override
    public void assignUser(UserAdminRole uAdminRole) throws SecurityException {
        VUtil.assertNotNull(uAdminRole, 9007, CLS_NM + ".assignUser");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAdminRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleAsgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deassignUser(UserAdminRole uAdminRole) throws SecurityException {
        VUtil.assertNotNull(uAdminRole, 9007, CLS_NM + ".deassignUser");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAdminRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleDeasgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public OrgUnit add(OrgUnit entity) throws SecurityException {
        VUtil.assertNotNull(entity, 8001, CLS_NM + ".addOU");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(entity);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        OrgUnit retOrg = (OrgUnit)response.getEntity();
        return retOrg;
    }

    @Override
    public OrgUnit update(OrgUnit entity) throws SecurityException {
        VUtil.assertNotNull(entity, 8001, CLS_NM + ".updateOU");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(entity);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        OrgUnit retOrg = (OrgUnit)response.getEntity();
        return retOrg;
    }

    @Override
    public OrgUnit delete(OrgUnit entity) throws SecurityException {
        VUtil.assertNotNull(entity, 8001, CLS_NM + ".deleteOU");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(entity);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        OrgUnit retOrg = (OrgUnit)response.getEntity();
        return retOrg;
    }

    @Override
    public void addDescendant(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "addDescendantOU";
        VUtil.assertNotNull(parent, 8072, CLS_NM + "." + methodName);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        VUtil.assertNotNull(child, 8073, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        OrgUnitRelationship relationship = new OrgUnitRelationship();
        relationship.setParent(parent);
        relationship.setChild(child);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgDescendant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addAscendant(OrgUnit child, OrgUnit parent) throws SecurityException {
        String methodName = "addAscendantOU";
        VUtil.assertNotNull(parent, 8072, CLS_NM + "." + methodName);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        OrgUnitRelationship relationship = new OrgUnitRelationship();
        relationship.setParent(parent);
        relationship.setChild(child);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgAscendent");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addInheritance(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "addInheritanceOU";
        VUtil.assertNotNull(parent, 8072, CLS_NM + "." + methodName);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        VUtil.assertNotNull(child, 8073, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        OrgUnitRelationship relationship = new OrgUnitRelationship();
        relationship.setParent(parent);
        relationship.setChild(child);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgAddinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deleteInheritance(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "deleteInheritanceOU";
        VUtil.assertNotNull(parent, 8072, CLS_NM + "." + methodName);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        VUtil.assertNotNull(child, 8073, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        OrgUnitRelationship relationship = new OrgUnitRelationship();
        relationship.setParent(parent);
        relationship.setChild(child);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgDelinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addDescendant(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "addDescendantRole";
        VUtil.assertNotNull(parentRole, 9019, CLS_NM + "." + methodName);
        VUtil.assertNotNull(childRole, 9020, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        AdminRoleRelationship relationship = new AdminRoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleDescendant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addAscendant(AdminRole childRole, AdminRole parentRole) throws SecurityException {
        String methodName = "addAscendantRole";
        VUtil.assertNotNull(parentRole, 9019, CLS_NM + "." + methodName);
        VUtil.assertNotNull(childRole, 9020, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        AdminRoleRelationship relationship = new AdminRoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleAscendent");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addInheritance(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "addInheritanceRole";
        VUtil.assertNotNull(parentRole, 9019, CLS_NM + "." + methodName);
        VUtil.assertNotNull(childRole, 9020, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        AdminRoleRelationship relationship = new AdminRoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleAddinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deleteInheritance(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "deleteInheritanceRole";
        VUtil.assertNotNull(parentRole, 9019, CLS_NM + "." + methodName);
        VUtil.assertNotNull(childRole, 9020, CLS_NM + "." + methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        AdminRoleRelationship relationship = new AdminRoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleDelinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public Permission addPermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".addPermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        perm.setAdmin(true);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Permission retPerm = (Permission)response.getEntity();
        return retPerm;
    }

    @Override
    public Permission updatePermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".updatePermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        perm.setAdmin(true);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Permission retPerm = (Permission)response.getEntity();
        return retPerm;
    }

    @Override
    public void deletePermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".deletePermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        perm.setAdmin(true);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public PermObj addPermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".addPermObj");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        pObj.setAdmin(true);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermObj retObj = (PermObj)response.getEntity();
        return retObj;
    }

    @Override
    public PermObj updatePermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".updatePermObj");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        pObj.setAdmin(true);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermObj retObj = (PermObj)response.getEntity();
        return retObj;
    }

    @Override
    public void deletePermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".deletePermObj");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        pObj.setAdmin(true);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void grantPermission(Permission perm, AdminRole role) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".grantPermission");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".grantPermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(true);
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setRoleNm(role.getName());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleGrant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void revokePermission(Permission perm, AdminRole role) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".revokePermission");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".revokePermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(true);
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setRoleNm(role.getName());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleRevoke");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void grantPermission(Permission perm, User user) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".grantPermissionUser");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".grantPermissionUser");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(true);
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setUserId(user.getUserId());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userGrant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void revokePermission(Permission perm, User user) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".revokePermission");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".revokePermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(true);
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setUserId(user.getUserId());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userRevoke");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

