/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.studio.apacheds.configuration.actions.EditorExportConfigurationAction;
import org.apache.directory.studio.apacheds.configuration.actions.EditorImportConfigurationAction;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.common.ui.CommonUIPlugin;
import org.apache.directory.studio.connection.core.Connection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ServerConfigurationEditorPage
extends FormPage {
    protected static final int DEFAULT_PORT_LDAP = 10389;
    protected static final int DEFAULT_PORT_LDAPS = 10636;
    protected static final int DEFAULT_PORT_KERBEROS = 60088;
    protected static final int DEFAULT_PORT_CHANGE_PASSWORD = 60464;
    protected static final String DEFAULT_ADDRESS = "0.0.0.0";
    protected static final String TABULATION = "      ";
    protected boolean isInitialized = false;
    private ModifyListener dirtyModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };
    private SelectionListener dirtySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener dirtySelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };

    public ServerConfigurationEditorPage(ServerConfigurationEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    public ServerConfigurationEditor getServerConfigurationEditor() {
        return (ServerConfigurationEditor)this.getEditor();
    }

    protected void setEditorDirty() {
        this.getServerConfigurationEditor().setDirty(true);
    }

    public ConfigBean getConfigBean() {
        Configuration configuration = this.getServerConfigurationEditor().getConfiguration();
        if (configuration == null) {
            configuration = new Configuration(new ConfigBean(), null);
            this.getServerConfigurationEditor().setConfiguration(configuration);
        }
        return configuration.getConfigBean();
    }

    public DirectoryServiceBean getDirectoryServiceBean() {
        DirectoryServiceBean directoryServiceBean = this.getConfigBean().getDirectoryServiceBean();
        if (directoryServiceBean == null) {
            directoryServiceBean = new DirectoryServiceBean();
            this.getConfigBean().addDirectoryService(new DirectoryServiceBean[]{directoryServiceBean});
        }
        return directoryServiceBean;
    }

    public Connection getConnection() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ConnectionServerConfigurationInput) {
            return ((ConnectionServerConfigurationInput)editorInput).getConnection();
        }
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        Composite parent = form.getBody();
        parent.setLayout((Layout)new GridLayout());
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        ServerConfigurationEditor editor = (ServerConfigurationEditor)this.getEditor();
        IToolBarManager toolbarManager = form.getToolBarManager();
        toolbarManager.add((IAction)new EditorImportConfigurationAction(editor));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new EditorExportConfigurationAction(editor));
        toolbarManager.update(true);
        this.createFormContent(parent, toolkit);
        this.isInitialized = true;
    }

    protected abstract void createFormContent(Composite var1, FormToolkit var2);

    protected abstract void refreshUI();

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected Text createPortText(FormToolkit toolkit, Composite parent) {
        Text portText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        portText.setLayoutData((Object)gd);
        portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] port = e.text.trim().toCharArray();
                if (port.length > 0) {
                    char[] cArray = port;
                    int n = port.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c < '0' || c > '9') {
                            e.doit = false;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        portText.setTextLimit(5);
        return portText;
    }

    protected Text createAddressText(FormToolkit toolkit, Composite parent) {
        Text addressText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 200;
        addressText.setLayoutData((Object)gd);
        addressText.addModifyListener(new ModifyListener(addressText){
            Display display;
            {
                this.display = text.getDisplay();
            }

            public void modifyText(ModifyEvent e) {
                Text addressText = (Text)e.widget;
                String address = addressText.getText();
                try {
                    InetAddress.getAllByName(address);
                    addressText.setForeground(null);
                }
                catch (UnknownHostException unknownHostException) {
                    addressText.setForeground(this.display.getSystemColor(3));
                }
            }
        });
        addressText.setTextLimit(256);
        return addressText;
    }

    protected Text createNbThreadsText(FormToolkit toolkit, Composite parent) {
        Text nbThreadsText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        nbThreadsText.setLayoutData((Object)gd);
        nbThreadsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] nbThreads = e.text.trim().toCharArray();
                if (nbThreads.length > 0) {
                    char[] cArray = nbThreads;
                    int n = nbThreads.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c < '0' || c > '9') {
                            e.doit = false;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        nbThreadsText.setTextLimit(3);
        return nbThreadsText;
    }

    protected Text createBackLogSizeText(FormToolkit toolkit, Composite parent) {
        Text backLogSizetText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        backLogSizetText.setLayoutData((Object)gd);
        backLogSizetText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] backlogSize = e.text.trim().toCharArray();
                if (backlogSize.length > 0) {
                    char[] cArray = backlogSize;
                    int n = backlogSize.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c < '0' || c > '9') {
                            e.doit = false;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        backLogSizetText.setTextLimit(5);
        return backLogSizetText;
    }

    protected Label createDefaultValueLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, NLS.bind((String)Messages.getString("ServerConfigurationEditorPage.DefaultWithValue"), (Object)text), 64);
        label.setForeground(CommonUIPlugin.getDefault().getColor("keyword1Color"));
        return label;
    }

    protected Label setBold(Label label) {
        FontData fontData = label.getFont().getFontData()[0];
        Font boldFont = JFaceResources.getFontRegistry().getBold(fontData.getName());
        label.setFont(boldFont);
        return label;
    }

    protected void addModifyListener(Text text, ModifyListener listener) {
        if (text != null && !text.isDisposed() && listener != null) {
            text.addModifyListener(listener);
        }
    }

    protected void addSelectionChangedListener(Viewer viewer, ISelectionChangedListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.addSelectionChangedListener(listener);
        }
    }

    protected void addDoubleClickListener(StructuredViewer viewer, IDoubleClickListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.addDoubleClickListener(listener);
        }
    }

    protected void addSelectionListener(Button button, SelectionListener listener) {
        if (button != null && !button.isDisposed() && listener != null) {
            button.addSelectionListener(listener);
        }
    }

    protected void removeModifyListener(Text text, ModifyListener listener) {
        if (text != null && !text.isDisposed() && listener != null) {
            text.removeModifyListener(listener);
        }
    }

    protected void removeSelectionChangedListener(Viewer viewer, ISelectionChangedListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.removeSelectionChangedListener(listener);
        }
    }

    protected void removeDoubleClickListener(StructuredViewer viewer, IDoubleClickListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.removeDoubleClickListener(listener);
        }
    }

    protected void removeSelectionListener(Button button, SelectionListener listener) {
        if (button != null && !button.isDisposed() && listener != null) {
            button.removeSelectionListener(listener);
        }
    }

    protected void addDirtyListener(Text text) {
        this.addModifyListener(text, this.dirtyModifyListener);
    }

    protected void addDirtyListener(Button button) {
        this.addSelectionListener(button, this.dirtySelectionListener);
    }

    protected void addDirtyListener(Viewer viewer) {
        this.addSelectionChangedListener(viewer, this.dirtySelectionChangedListener);
    }

    protected void removeDirtyListener(Text text) {
        this.removeModifyListener(text, this.dirtyModifyListener);
    }

    protected void removeDirtyListener(Button button) {
        this.removeSelectionListener(button, this.dirtySelectionListener);
    }

    protected void removeDirtyListener(Viewer viewer) {
        this.removeSelectionChangedListener(viewer, this.dirtySelectionChangedListener);
    }

    protected void setSelection(Button button, boolean selected) {
        if (button != null && !button.isDisposed()) {
            button.setSelection(selected);
        }
    }

    protected void setSelection(Viewer viewer, Object selection) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected void setText(Text text, String string) {
        if (text != null && !text.isDisposed()) {
            if (string == null) {
                string = "";
            }
            text.setText(string);
        }
    }

    protected void setFocus(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    protected void setEnabled(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(enabled);
        }
    }

    protected void setGridDataWithDefaultWidth(Control control, GridData gd) {
        gd.widthHint = 50;
        control.setLayoutData((Object)gd);
    }

    protected Composite createSection(FormToolkit toolkit, Composite parent, String title, int nbColumns, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(Messages.getString(title));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(nbColumns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        return composite;
    }
}

