/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.events;

import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.EventRunnable;
import org.apache.directory.studio.connection.core.event.EventRunnableFactory;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;

public class EventRegistry
extends ConnectionEventRegistry {
    static final ConnectionEventRegistry.EventManager<SearchUpdateListener, EventRunner> searchUpdateEventManager = new ConnectionEventRegistry.EventManager();
    static final ConnectionEventRegistry.EventManager<BookmarkUpdateListener, EventRunner> bookmarkUpdateEventManager = new ConnectionEventRegistry.EventManager();
    static final ConnectionEventRegistry.EventManager<BrowserConnectionUpdateListener, EventRunner> browserConnectionUpdateEventManager = new ConnectionEventRegistry.EventManager();
    static final ConnectionEventRegistry.EventManager<EntryUpdateListener, EventRunner> entryUpdateEventManager = new ConnectionEventRegistry.EventManager();

    public static void addSearchUpdateListener(SearchUpdateListener listener, EventRunner runner) {
        searchUpdateEventManager.addListener((Object)listener, runner);
    }

    public static void removeSearchUpdateListener(SearchUpdateListener listener) {
        searchUpdateEventManager.removeListener((Object)listener);
    }

    public static void fireSearchUpdated(final SearchUpdateEvent searchUpdateEvent, Object source) {
        EventRunnableFactory<SearchUpdateListener> factory = new EventRunnableFactory<SearchUpdateListener>(){

            public EventRunnable createEventRunnable(final SearchUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.searchUpdated(searchUpdateEvent);
                    }
                };
            }
        };
        searchUpdateEventManager.fire((EventRunnableFactory)factory);
    }

    public static void addBookmarkUpdateListener(BookmarkUpdateListener listener, EventRunner runner) {
        bookmarkUpdateEventManager.addListener((Object)listener, runner);
    }

    public static void removeBookmarkUpdateListener(BookmarkUpdateListener listener) {
        bookmarkUpdateEventManager.removeListener((Object)listener);
    }

    public static void fireBookmarkUpdated(final BookmarkUpdateEvent bookmarkUpdateEvent, Object source) {
        EventRunnableFactory<BookmarkUpdateListener> factory = new EventRunnableFactory<BookmarkUpdateListener>(){

            public EventRunnable createEventRunnable(final BookmarkUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.bookmarkUpdated(bookmarkUpdateEvent);
                    }
                };
            }
        };
        bookmarkUpdateEventManager.fire((EventRunnableFactory)factory);
    }

    public static void addBrowserConnectionUpdateListener(BrowserConnectionUpdateListener listener, EventRunner runner) {
        browserConnectionUpdateEventManager.addListener((Object)listener, runner);
    }

    public static void removeBrowserConnectionUpdateListener(BrowserConnectionUpdateListener listener) {
        browserConnectionUpdateEventManager.removeListener((Object)listener);
    }

    public static void fireBrowserConnectionUpdated(final BrowserConnectionUpdateEvent browserConnectionUpdateEvent, Object source) {
        EventRunnableFactory<BrowserConnectionUpdateListener> factory = new EventRunnableFactory<BrowserConnectionUpdateListener>(){

            public EventRunnable createEventRunnable(final BrowserConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.browserConnectionUpdated(browserConnectionUpdateEvent);
                    }
                };
            }
        };
        browserConnectionUpdateEventManager.fire((EventRunnableFactory)factory);
    }

    public static void addEntryUpdateListener(EntryUpdateListener listener, EventRunner runner) {
        entryUpdateEventManager.addListener((Object)listener, runner);
    }

    public static void removeEntryUpdateListener(EntryUpdateListener listener) {
        entryUpdateEventManager.removeListener((Object)listener);
    }

    public static void fireEntryUpdated(final EntryModificationEvent entryUpdateEvent, Object source) {
        entryUpdateEvent.setSource(source);
        EventRunnableFactory<EntryUpdateListener> factory = new EventRunnableFactory<EntryUpdateListener>(){

            public EventRunnable createEventRunnable(final EntryUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.entryUpdated(entryUpdateEvent);
                    }
                };
            }

            public String toString() {
                return "EventRunnableFactory [entryUpdateEvent=" + entryUpdateEvent + "]";
            }
        };
        entryUpdateEventManager.fire((EventRunnableFactory)factory);
    }
}

