/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.Dsmlv2Parser;
import org.apache.directory.api.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.api.dsmlv2.request.Dsmlv2Grammar;
import org.apache.directory.api.dsmlv2.response.AddResponseDsml;
import org.apache.directory.api.dsmlv2.response.BatchResponseDsml;
import org.apache.directory.api.dsmlv2.response.BindResponseDsml;
import org.apache.directory.api.dsmlv2.response.CompareResponseDsml;
import org.apache.directory.api.dsmlv2.response.DelResponseDsml;
import org.apache.directory.api.dsmlv2.response.ExtendedResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModDNResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModifyResponseDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.LdapRuntimeException;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportDsmlRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImportDsmlRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private File dsmlFile;
    private File responseFile;
    private LdapApiService codec = LdapApiServiceFactory.getSingleton();

    public ImportDsmlRunnable(IBrowserConnection connection, File dsmlFile, File saveFile) {
        this.browserConnection = connection;
        this.dsmlFile = dsmlFile;
        this.responseFile = saveFile;
    }

    public ImportDsmlRunnable(IBrowserConnection connection, File dsmlFile) {
        this(connection, dsmlFile, null);
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__import_dsml_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.dsmlFile.toString()));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__import_dsml_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__import_dsml_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            Dsmlv2Grammar grammar = new Dsmlv2Grammar();
            Dsmlv2Parser parser = new Dsmlv2Parser(grammar);
            parser.setInput((InputStream)new FileInputStream(this.dsmlFile), "UTF-8");
            parser.parseAllRequests();
            BatchRequestDsml batchRequest = parser.getBatchRequest();
            BatchResponseDsml batchResponseDsml = null;
            if (this.responseFile != null) {
                batchResponseDsml = new BatchResponseDsml();
            }
            int errorsCount = 0;
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            List requests = batchRequest.getRequests();
            for (DsmlDecorator request : requests) {
                this.processRequest((DsmlDecorator<? extends Request>)request, batchResponseDsml, dummyMonitor);
                if (dummyMonitor.errorsReported()) {
                    ++errorsCount;
                }
                dummyMonitor.reset();
            }
            if (this.responseFile != null) {
                FileOutputStream fos = new FileOutputStream(this.responseFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(osw);
                bufferedWriter.write(batchResponseDsml.toDsml());
                bufferedWriter.close();
                osw.close();
                fos.close();
            }
            if (errorsCount > 0) {
                monitor.reportError(BrowserCoreMessages.bind((String)BrowserCoreMessages.dsml__n_errors_see_responsefile, (Object[])new String[]{"" + errorsCount}));
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), this);
    }

    private void processRequest(DsmlDecorator<? extends Request> request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) throws LdapURLEncodingException, LdapException {
        switch (((Request)request.getDecorated()).getType()) {
            case BIND_REQUEST: {
                this.processBindRequest((BindRequest)request, batchResponseDsml, monitor);
                break;
            }
            case ADD_REQUEST: {
                this.processAddRequest((AddRequest)request, batchResponseDsml, monitor);
                break;
            }
            case COMPARE_REQUEST: {
                this.processCompareRequest((CompareRequest)request, batchResponseDsml, monitor);
                break;
            }
            case DEL_REQUEST: {
                this.processDelRequest((DeleteRequest)request, batchResponseDsml, monitor);
                break;
            }
            case EXTENDED_REQUEST: {
                this.processExtendedRequest((ExtendedRequest)request, batchResponseDsml, monitor);
                break;
            }
            case MODIFY_REQUEST: {
                this.processModifyRequest((ModifyRequest)request, batchResponseDsml, monitor);
                break;
            }
            case MODIFYDN_REQUEST: {
                this.processModifyDNRequest((ModifyDnRequest)request, batchResponseDsml, monitor);
                break;
            }
            case SEARCH_REQUEST: {
                this.processSearchRequest((SearchRequest)request, batchResponseDsml, monitor);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(BrowserCoreMessages.dsml__should_not_be_encountering_request) + ((Request)request.getDecorated()).getType());
            }
        }
    }

    private void processBindRequest(BindRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            BindResponseDsml authResponseDsml = new BindResponseDsml(this.codec);
            LdapResult ldapResult = authResponseDsml.getLdapResult();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setDiagnosticMessage(BrowserCoreMessages.dsml__kind_request_not_supported);
            batchResponseDsml.addResponse((DsmlDecorator)authResponseDsml);
        }
    }

    private void processAddRequest(AddRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        IEntry parentEntry;
        Entry entry = request.getEntry();
        this.browserConnection.getConnection().getConnectionWrapper().createEntry(entry, this.getControls((Message)request), monitor, null);
        if (batchResponseDsml != null) {
            AddResponseDsml addResponseDsml = new AddResponseDsml(this.codec);
            LdapResult ldapResult = addResponseDsml.getLdapResult();
            this.setLdapResultValuesFromMonitor(ldapResult, monitor, MessageTypeEnum.ADD_REQUEST);
            ldapResult.setMatchedDn(entry.getDn());
            batchResponseDsml.addResponse((DsmlDecorator)addResponseDsml);
        }
        Dn dn = entry.getDn();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        Dn parentDn = dn.getParent();
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
    }

    private void processCompareRequest(CompareRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            CompareResponseDsml compareResponseDsml = new CompareResponseDsml(this.codec);
            LdapResult ldapResult = compareResponseDsml.getLdapResult();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setDiagnosticMessage(BrowserCoreMessages.dsml__kind_request_not_supported);
            batchResponseDsml.addResponse((DsmlDecorator)compareResponseDsml);
        }
    }

    private void processDelRequest(DeleteRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        IEntry parentEntry;
        this.browserConnection.getConnection().getConnectionWrapper().deleteEntry(request.getName(), this.getControls((Message)request), monitor, null);
        if (batchResponseDsml != null) {
            DelResponseDsml delResponseDsml = new DelResponseDsml(this.codec);
            LdapResult ldapResult = delResponseDsml.getLdapResult();
            this.setLdapResultValuesFromMonitor(ldapResult, monitor, MessageTypeEnum.ADD_REQUEST);
            delResponseDsml.getLdapResult().setMatchedDn(request.getName());
            batchResponseDsml.addResponse((DsmlDecorator)delResponseDsml);
        }
        Dn dn = request.getName();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        Dn parentDn = dn.getParent();
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
            this.browserConnection.uncacheEntryRecursive(e);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
    }

    private void processExtendedRequest(ExtendedRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            ExtendedResponseDsml extendedResponseDsml = new ExtendedResponseDsml(this.codec);
            LdapResult ldapResult = extendedResponseDsml.getLdapResult();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setDiagnosticMessage(BrowserCoreMessages.dsml__kind_request_not_supported);
            batchResponseDsml.addResponse((DsmlDecorator)extendedResponseDsml);
        }
    }

    private void processModifyRequest(ModifyRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        Dn dn;
        IEntry e;
        this.browserConnection.getConnection().getConnectionWrapper().modifyEntry(request.getName(), request.getModifications(), this.getControls((Message)request), monitor, null);
        if (batchResponseDsml != null) {
            ModifyResponseDsml modifyResponseDsml = new ModifyResponseDsml(this.codec);
            LdapResult ldapResult = modifyResponseDsml.getLdapResult();
            this.setLdapResultValuesFromMonitor(ldapResult, monitor, MessageTypeEnum.ADD_REQUEST);
            modifyResponseDsml.getLdapResult().setMatchedDn(request.getName());
            batchResponseDsml.addResponse((DsmlDecorator)modifyResponseDsml);
        }
        if ((e = this.browserConnection.getEntryFromCache(dn = request.getName())) != null) {
            e.setAttributesInitialized(false);
        }
    }

    private void processModifyDNRequest(ModifyDnRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        Dn newSuperiorDn;
        IEntry newSuperiorEntry;
        IEntry parentEntry;
        Dn newDn;
        try {
            newDn = request.isMove() ? new Dn(request.getNewRdn(), request.getNewSuperior()) : new Dn(request.getNewRdn(), request.getName().getParent());
        }
        catch (LdapInvalidDnException e) {
            throw new LdapRuntimeException((LdapException)((Object)e));
        }
        this.browserConnection.getConnection().getConnectionWrapper().renameEntry(request.getName(), newDn, request.getDeleteOldRdn(), this.getControls((Message)request), monitor, null);
        if (batchResponseDsml != null) {
            ModDNResponseDsml modDNResponseDsml = new ModDNResponseDsml(this.codec);
            LdapResult ldapResult = modDNResponseDsml.getLdapResult();
            this.setLdapResultValuesFromMonitor(ldapResult, monitor, MessageTypeEnum.ADD_REQUEST);
            modDNResponseDsml.getLdapResult().setMatchedDn(request.getName());
            batchResponseDsml.addResponse((DsmlDecorator)modDNResponseDsml);
        }
        Dn dn = request.getName();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        Dn parentDn = dn.getParent();
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
            this.browserConnection.uncacheEntryRecursive(e);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
        if (request.getNewSuperior() != null && (newSuperiorEntry = this.browserConnection.getEntryFromCache(newSuperiorDn = request.getNewSuperior())) != null) {
            newSuperiorEntry.setChildrenInitialized(false);
        }
    }

    private void processSearchRequest(SearchRequest request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) throws LdapURLEncodingException, LdapException {
        if (batchResponseDsml != null) {
            StudioSearchResultEnumeration sre = this.browserConnection.getConnection().getConnectionWrapper().search(request.getBase().getName(), request.getFilter().toString(), this.getSearchControls(request), this.getAliasDereferencingMethod(request), Connection.ReferralHandlingMethod.IGNORE, this.getControls((Message)request), monitor, null);
            SearchParameter sp = new SearchParameter();
            sp.setReferralsHandlingMethod(this.browserConnection.getReferralsHandlingMethod());
            ExportDsmlRunnable.processAsDsmlResponse(sre, batchResponseDsml, monitor, sp);
        }
    }

    private SearchControls getSearchControls(SearchRequest request) {
        SearchControls controls = new SearchControls();
        switch (request.getScope()) {
            case OBJECT: {
                controls.setSearchScope(0);
                break;
            }
            case ONELEVEL: {
                controls.setSearchScope(1);
                break;
            }
            case SUBTREE: {
                controls.setSearchScope(2);
                break;
            }
            default: {
                controls.setSearchScope(1);
            }
        }
        ArrayList<String> returningAttributes = new ArrayList<String>();
        for (String attribute : request.getAttributes()) {
            returningAttributes.add(attribute);
        }
        if (returningAttributes.size() == 0) {
            returningAttributes.add("*");
        }
        controls.setReturningAttributes(returningAttributes.toArray(new String[0]));
        controls.setCountLimit(request.getSizeLimit());
        controls.setTimeLimit(request.getTimeLimit());
        return controls;
    }

    private Connection.AliasDereferencingMethod getAliasDereferencingMethod(SearchRequest request) {
        switch (request.getDerefAliases()) {
            case NEVER_DEREF_ALIASES: {
                return Connection.AliasDereferencingMethod.NEVER;
            }
            case DEREF_ALWAYS: {
                return Connection.AliasDereferencingMethod.ALWAYS;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return Connection.AliasDereferencingMethod.FINDING;
            }
            case DEREF_IN_SEARCHING: {
                return Connection.AliasDereferencingMethod.SEARCH;
            }
        }
        return Connection.AliasDereferencingMethod.NEVER;
    }

    private Control[] getControls(Message request) {
        Collection controls = request.getControls().values();
        if (controls != null) {
            return controls.toArray(new Control[0]);
        }
        return null;
    }

    private void setLdapResultValuesFromMonitor(LdapResult ldapResult, StudioProgressMonitor monitor, MessageTypeEnum messageType) {
        if (!monitor.errorsReported()) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        } else {
            Exception t = monitor.getException();
            ldapResult.setResultCode(ResultCodeEnum.getBestEstimate((Throwable)t, (MessageTypeEnum)messageType));
            if (t.getMessage() != null) {
                ldapResult.setDiagnosticMessage(t.getMessage());
            }
        }
    }
}

