/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConnectionContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ConnectionFolderManager) {
            ConnectionFolderManager cfm = (ConnectionFolderManager)inputElement;
            ConnectionFolder rootConnectionFolder = cfm.getRootConnectionFolder();
            return this.getChildren(rootConnectionFolder);
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ConnectionFolder) {
            ArrayList<Object> children = new ArrayList<Object>();
            ConnectionFolder folder = (ConnectionFolder)parentElement;
            List subFolderIds = folder.getSubFolderIds();
            List connectionIds = folder.getConnectionIds();
            for (String subFolderId : subFolderIds) {
                ConnectionFolder subFolder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderById(subFolderId);
                if (subFolder == null) continue;
                children.add(subFolder);
            }
            for (String connectionId : connectionIds) {
                Connection conn = ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionById(connectionId);
                if (conn == null) continue;
                children.add(conn);
            }
            return children.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ConnectionFolder) {
            return ConnectionCorePlugin.getDefault().getConnectionFolderManager().getParentConnectionFolder((ConnectionFolder)element);
        }
        if (element instanceof Connection) {
            return ConnectionCorePlugin.getDefault().getConnectionFolderManager().getParentConnectionFolder((Connection)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }
}

