/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.MultiValuedDialog;
import org.apache.directory.studio.aciitemeditor.model.ProtectedItemWrapper;
import org.apache.directory.studio.aciitemeditor.model.ProtectedItemWrapperFactory;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ACIItemProtectedItemsComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private CheckboxTableViewer tableViewer = null;
    private Button editButton = null;
    private ProtectedItemWrapper[] protectedItemWrappers = ProtectedItemWrapperFactory.createProtectedItemWrappers();

    public ACIItemProtectedItemsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(Messages.getString("ACIItemProtectedItemsComposite.description"));
        label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        Table table = new Table(this.composite, 2080);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)tableGridData);
        table.setLinesVisible(false);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProtectedItemsLabelProvider());
        this.tableViewer.setInput((Object)this.protectedItemWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemProtectedItemsComposite.this.protectedItemSelected();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ACIItemProtectedItemsComposite.this.protectedItemChecked();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ACIItemProtectedItemsComposite.this.editButton.isEnabled()) {
                    ACIItemProtectedItemsComposite.this.editProtectedItem();
                }
            }
        });
    }

    private void createButtonComposite() {
        GridData reverseSelectionButtonGridData = new GridData();
        reverseSelectionButtonGridData.horizontalAlignment = 4;
        reverseSelectionButtonGridData.grabExcessHorizontalSpace = false;
        reverseSelectionButtonGridData.verticalAlignment = 1;
        reverseSelectionButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData deselectAllButtonGridData = new GridData();
        deselectAllButtonGridData.horizontalAlignment = 4;
        deselectAllButtonGridData.grabExcessHorizontalSpace = false;
        deselectAllButtonGridData.verticalAlignment = 1;
        deselectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData selectAllButtonGridData = new GridData();
        selectAllButtonGridData.horizontalAlignment = 4;
        selectAllButtonGridData.grabExcessHorizontalSpace = false;
        selectAllButtonGridData.verticalAlignment = 1;
        selectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)gridLayout);
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemProtectedItemsComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.editProtectedItem();
            }
        });
        this.editButton.setEnabled(false);
        Button selectAllButton = new Button(buttonComposite, 0);
        selectAllButton.setText(Messages.getString("ACIItemProtectedItemsComposite.selectAll.button"));
        selectAllButton.setLayoutData((Object)selectAllButtonGridData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements((Object[])ACIItemProtectedItemsComposite.this.protectedItemWrappers);
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 0);
        deselectAllButton.setText(Messages.getString("ACIItemProtectedItemsComposite.deselectAll.button"));
        deselectAllButton.setLayoutData((Object)deselectAllButtonGridData);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements((Object[])new ProtectedItem[0]);
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
        Button reverseSelectionButton = new Button(buttonComposite, 0);
        reverseSelectionButton.setText(Messages.getString("ACIItemProtectedItemsComposite.revers.button"));
        reverseSelectionButton.setLayoutData((Object)reverseSelectionButtonGridData);
        reverseSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ProtectedItemWrapper> elements = new ArrayList<ProtectedItemWrapper>();
                elements.addAll(Arrays.asList(ACIItemProtectedItemsComposite.this.protectedItemWrappers));
                elements.removeAll(Arrays.asList(ACIItemProtectedItemsComposite.this.tableViewer.getCheckedElements()));
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements(elements.toArray());
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setProtectedItems(Collection<ProtectedItem> protectedItems) {
        ProtectedItemWrapper[] protectedItemWrapperArray = this.protectedItemWrappers;
        int n = this.protectedItemWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            ProtectedItemWrapper protectedItemWrapper = protectedItemWrapperArray[n2];
            this.tableViewer.setChecked((Object)protectedItemWrapper, false);
            ++n2;
        }
        for (ProtectedItem item : protectedItems) {
            ProtectedItemWrapper[] protectedItemWrapperArray2 = this.protectedItemWrappers;
            int n3 = this.protectedItemWrappers.length;
            int n4 = 0;
            while (n4 < n3) {
                ProtectedItemWrapper protectedItemWrapper = protectedItemWrapperArray2[n4];
                if (protectedItemWrapper.getClazz() == item.getClass()) {
                    protectedItemWrapper.setProtectedItem(item);
                    this.tableViewer.setChecked((Object)protectedItemWrapper, true);
                }
                ++n4;
            }
        }
        this.refreshTable();
    }

    public Collection<ProtectedItem> getProtectedItems() throws ParseException {
        ArrayList<ProtectedItem> protectedItems = new ArrayList<ProtectedItem>();
        ProtectedItemWrapper[] protectedItemWrapperArray = this.protectedItemWrappers;
        int n = this.protectedItemWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            ProtectedItemWrapper protectedItemWrapper = protectedItemWrapperArray[n2];
            if (this.tableViewer.getChecked((Object)protectedItemWrapper)) {
                ProtectedItem protectedItem = protectedItemWrapper.getProtectedItem();
                protectedItems.add(protectedItem);
            }
            ++n2;
        }
        return protectedItems;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    private ProtectedItemWrapper getSelectedProtectedItemWrapper() {
        Object element;
        ProtectedItemWrapper protectedItemWrapper = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof ProtectedItemWrapper) {
            protectedItemWrapper = (ProtectedItemWrapper)element;
        }
        return protectedItemWrapper;
    }

    private void protectedItemSelected() {
        ProtectedItemWrapper protectedItemWrapper = this.getSelectedProtectedItemWrapper();
        if (protectedItemWrapper == null || !protectedItemWrapper.isEditable()) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
    }

    private void protectedItemChecked() {
        this.refreshTable();
    }

    private void editProtectedItem() {
        ProtectedItemWrapper protectedItemWrapper = this.getSelectedProtectedItemWrapper();
        AbstractDialogStringValueEditor valueEditor = protectedItemWrapper.getValueEditor();
        if (valueEditor != null) {
            if (protectedItemWrapper.isMultivalued()) {
                MultiValuedDialog dialog = new MultiValuedDialog(this.getShell(), protectedItemWrapper.getDisplayName(), protectedItemWrapper.getValues(), this.context, valueEditor);
                dialog.open();
                this.refreshTable();
            } else {
                String oldValue;
                List<String> values = protectedItemWrapper.getValues();
                String string = oldValue = values.isEmpty() ? null : values.get(0);
                if (oldValue == null) {
                    oldValue = "";
                }
                Attribute attribute = new Attribute(this.context.getEntry(), "");
                Value value = new Value((IAttribute)attribute, (Object)oldValue);
                Object oldRawValue = valueEditor.getRawValue((IValue)value);
                CellEditor cellEditor = valueEditor.getCellEditor();
                cellEditor.setValue(oldRawValue);
                cellEditor.activate();
                Object newRawValue = cellEditor.getValue();
                if (newRawValue != null) {
                    String newValue = (String)valueEditor.getStringOrBinaryValue(newRawValue);
                    values.clear();
                    values.add(newValue);
                    this.tableViewer.refresh();
                }
            }
        }
    }

    private void refreshTable() {
        this.tableViewer.refresh();
    }

    private class ProtectedItemsLabelProvider
    extends LabelProvider {
        private ProtectedItemsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ProtectedItemWrapper) {
                ProtectedItemWrapper wrapper = (ProtectedItemWrapper)element;
                if (ACIItemProtectedItemsComposite.this.tableViewer.getChecked((Object)wrapper)) {
                    try {
                        wrapper.getProtectedItem();
                    }
                    catch (ParseException parseException) {
                        return Activator.getDefault().getImage(Messages.getString("ACIItemProtectedItemsComposite.error.icon"));
                    }
                }
            }
            return null;
        }
    }
}

