/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.password;

import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogBinaryValueEditor;
import org.apache.directory.studio.valueeditors.password.Messages;
import org.apache.directory.studio.valueeditors.password.PasswordDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class PasswordValueEditor
extends AbstractDialogBinaryValueEditor {
    protected boolean openDialog(Shell shell) {
        byte[] pw;
        PasswordDialog dialog;
        PasswordValueEditorRawValueWrapper wrapper;
        Object value = this.getValue();
        if (value instanceof PasswordValueEditorRawValueWrapper && (wrapper = (PasswordValueEditorRawValueWrapper)value).password instanceof byte[] && (dialog = new PasswordDialog(shell, pw = (byte[])wrapper.password, wrapper.entry)).open() == 0) {
            this.setValue(dialog.getNewPassword());
            return true;
        }
        return false;
    }

    public String getDisplayValue(IValue value) {
        if (this.showRawValues()) {
            return PasswordValueEditor.getPrintableString((IValue)value);
        }
        if (value == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        String password = value.getStringValue();
        if (password == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        String text = "".equals(password) ? Messages.getString("PasswordValueEditor.EmptyPassword") : (password.indexOf(123) == 0 && password.indexOf(125) > 0 ? NLS.bind((String)Messages.getString("PasswordValueEditor.HashedPassword"), (Object)this.getHashMethodName(password)) : Messages.getString("PasswordValueEditor.PlainTextPassword"));
        return text;
    }

    private String getHashMethodName(String s) {
        LdapSecurityConstants hashMethod = PasswordUtil.findAlgorithm((byte[])Strings.getBytesUtf8((String)s));
        if (hashMethod != null) {
            return hashMethod.getName();
        }
        return s;
    }

    protected Object getEmptyRawValue(IAttribute attribute) {
        return new PasswordValueEditorRawValueWrapper(new byte[0], attribute.getEntry());
    }

    public Object getRawValue(IValue value) {
        Object password = super.getRawValue(value);
        return new PasswordValueEditorRawValueWrapper(password, value.getAttribute().getEntry());
    }

    private class PasswordValueEditorRawValueWrapper {
        private Object password;
        private IEntry entry;

        private PasswordValueEditorRawValueWrapper(Object password, IEntry entry) {
            this.password = password;
            this.entry = entry;
        }
    }
}

