/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.text.ParseException;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AbstractAttributeTypeEditorPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class AttributeTypeEditorSourceCodePage
extends AbstractAttributeTypeEditorPage {
    public static final String ID = String.valueOf(AttributeTypeEditor.ID) + "sourceCodePage";
    private SchemaSourceViewer schemaSourceViewer;
    private boolean canLeaveThePage = true;
    private ModifyListener schemaSourceViewerListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AttributeTypeEditorSourceCodePage.this.canLeaveThePage = true;
            try {
                ((AttributeTypeEditor)((Object)AttributeTypeEditorSourceCodePage.this.getEditor())).setDirty(true);
                OpenLdapSchemaParser parser = new OpenLdapSchemaParser();
                parser.parse(AttributeTypeEditorSourceCodePage.this.schemaSourceViewer.getTextWidget().getText());
                List attributeTypes = parser.getAttributeTypes();
                if (attributeTypes.size() == 1) {
                    AttributeTypeEditorSourceCodePage.this.updateAttributeType((AttributeType)attributeTypes.get(0));
                }
            }
            catch (ParseException parseException) {
                AttributeTypeEditorSourceCodePage.this.canLeaveThePage = false;
            }
        }
    };

    public AttributeTypeEditorSourceCodePage(AttributeTypeEditor editor) {
        super(editor, ID, Messages.getString("AttributeTypeEditorSourceCodePage.SourceCode"));
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "attribute_type_editor");
        this.initialized = true;
    }

    @Override
    protected void addListeners() {
        if (this.schemaSourceViewer != null) {
            this.addModifyListener(this.schemaSourceViewer.getTextWidget(), this.schemaSourceViewerListener);
        }
    }

    @Override
    protected void removeListeners() {
        if (this.schemaSourceViewer != null) {
            this.removeModifyListener(this.schemaSourceViewer.getTextWidget(), this.schemaSourceViewerListener);
        }
    }

    @Override
    protected void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.getModifiedAttributeType()));
    }

    public boolean canLeaveThePage() {
        return this.canLeaveThePage;
    }

    private void updateAttributeType(AttributeType atl) {
        AttributeType modifiedAttributeType = this.getModifiedAttributeType();
        modifiedAttributeType.setCollective(atl.isCollective());
        modifiedAttributeType.setDescription(atl.getDescription());
        modifiedAttributeType.setEqualityOid(atl.getEqualityOid());
        modifiedAttributeType.setSyntaxLength(atl.getSyntaxLength());
        modifiedAttributeType.setNames(atl.getNames());
        modifiedAttributeType.setObsolete(atl.isObsolete());
        modifiedAttributeType.setOid(atl.getOid());
        modifiedAttributeType.setOrderingOid(atl.getOrderingOid());
        modifiedAttributeType.setSingleValued(atl.isSingleValued());
        modifiedAttributeType.setSubstringOid(atl.getSubstringOid());
        modifiedAttributeType.setSuperiorOid(atl.getSuperiorOid());
        modifiedAttributeType.setSyntaxOid(atl.getSyntaxOid());
        modifiedAttributeType.setUsage(atl.getUsage());
        modifiedAttributeType.setUserModifiable(atl.isUserModifiable());
    }
}

