/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.filters;

import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.filters.AbstractFilterNode;
import java.util.ArrayList;
import java.util.List;

public class GradientGlowFilterNode
extends AbstractFilterNode {
    public double angle = 45.0;
    public double distance = 4.0;
    public double blurX = 4.0;
    public double blurY = 4.0;
    public boolean inner = false;
    public boolean knockout = false;
    public int quality = 1;
    public double strength = 1.0;
    public List<GradientEntryNode> entries;

    public void addChild(FXGNode child) {
        if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 15) {
                FXGLog.getLogger().log(30000, "InvalidGradientGlowFilterNumElements", null, this.getDocumentName(), this.startLine, this.startColumn);
                return;
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "GradientGlowFilter";
    }

    public void setAttribute(String name, String value) {
        if ("angle".equals(name)) {
            this.angle = DOMParserHelper.parseDouble(this, value, name);
        } else if ("blurX".equals(name)) {
            this.blurX = DOMParserHelper.parseDouble(this, value, name);
        } else if ("blurY".equals(name)) {
            this.blurY = DOMParserHelper.parseDouble(this, value, name);
        } else if ("distance".equals(name)) {
            this.distance = DOMParserHelper.parseDouble(this, value, name);
        } else if ("inner".equals(name)) {
            this.inner = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("knockout".equals(name)) {
            this.knockout = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("quality".equals(name)) {
            this.quality = DOMParserHelper.parseInt(this, value, name, 1, 3, this.quality);
        } else if ("strength".equals(name)) {
            this.strength = DOMParserHelper.parseDouble(this, value, name);
        } else {
            super.setAttribute(name, value);
        }
    }
}

