/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.Source;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.SelectorNode;

public class AtResource
implements LineNumberMapped {
    private String bundle;
    private String key;
    private String methodName;
    private int lineNumber;
    private static final String RESOURCE_MANAGER = "ResourceManager".intern();
    private static final String GET_INSTANCE = "getInstance".intern();

    public AtResource(String bundle, String key, String methodName, int lineNumber) {
        this.bundle = bundle;
        this.key = key;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getValueExpression() {
        return "ResourceManager.getInstance()." + this.methodName + "(\"" + this.bundle + "\", \"" + this.key + "\")";
    }

    public MemberExpressionNode getValueExpression(NodeFactory nodeFactory) {
        MemberExpressionNode resourceManagerMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, RESOURCE_MANAGER, false);
        IdentifierNode getInstanceIdentifier = nodeFactory.identifier(GET_INSTANCE, false);
        CallExpressionNode getInstanceCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)getInstanceIdentifier, null);
        getInstanceCallExpression.setRValue(false);
        MemberExpressionNode base = nodeFactory.memberExpression((Node)resourceManagerMemberExpression, (SelectorNode)getInstanceCallExpression);
        IdentifierNode methodNameIdentifier = nodeFactory.identifier(this.methodName);
        LiteralStringNode bundleLiteralString = nodeFactory.literalString(this.bundle);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)bundleLiteralString);
        LiteralStringNode keyLiteralString = nodeFactory.literalString(this.key);
        argumentList = nodeFactory.argumentList(argumentList, (Node)keyLiteralString);
        CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression((Node)methodNameIdentifier, argumentList);
        selector.setRValue(false);
        return nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
    }

    public int getXmlLineNumber() {
        return this.lineNumber;
    }

    public void setXmlLineNumber(int xmlLineNumber) {
        this.lineNumber = xmlLineNumber;
    }

    public static AtResource create(TypeTable typeTable, Source sourceFile, int beginLine, String value, Type type) {
        String bundle;
        String methodName = null;
        methodName = type.isAssignableTo(typeTable.stringType) ? "getString" : (type.isAssignableTo(typeTable.booleanType) ? "getBoolean" : (type.isAssignableTo(typeTable.numberType) ? "getNumber" : (type.isAssignableTo(typeTable.intType) ? "getInt" : (type.isAssignableTo(typeTable.uintType) ? "getUint" : (type.isAssignableTo(typeTable.classType) ? "getClass" : (type.isAssignableTo(typeTable.arrayType) ? "getStringArray" : "getObject"))))));
        MetaData metaData = MetaDataParser.parse(typeTable.getPerCompileData(), sourceFile, beginLine, value.substring(1));
        if (metaData == null) {
            return null;
        }
        if (metaData.count() == 0) {
            ThreadLocalToolkit.log((CompilerMessage)new NoResourceParams(), sourceFile.getNameForReporting(), beginLine);
            return null;
        }
        String key = metaData.getValue("key");
        if (key == null) {
            if (metaData.getKey(0) == null && metaData.count() == 1) {
                key = metaData.getValue(0);
            } else {
                ThreadLocalToolkit.log((CompilerMessage)new NoResourceKeyParam(), sourceFile.getNameForReporting(), beginLine);
                return null;
            }
        }
        if ((bundle = metaData.getValue("bundle")) == null) {
            if (metaData.count() > 1) {
                ThreadLocalToolkit.log((CompilerMessage)new NoResourceBundleParam(), sourceFile.getNameForReporting(), beginLine);
                return null;
            }
            bundle = NameFormatter.qNameFromSource(sourceFile).toString();
        }
        return new AtResource(bundle, key, methodName, beginLine);
    }

    public static class NoResourceBundleParam
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -9187717139110374442L;
    }

    public static class NoResourceKeyParam
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5866933214425791L;
    }

    public static class NoResourceParams
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1828011337558204205L;
    }
}

