/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

public class FieldFormat {
    public static final int ALIGN_UNKNOWN = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 3;

    public static StringBuilder formatLongToHex(StringBuilder sb, long v, int length) {
        return FieldFormat.formatLongToHex(sb, v, length, true);
    }

    public static StringBuilder formatLongToHex(StringBuilder sb, long v, int length, boolean leadingZeros) {
        return FieldFormat.format(sb, Long.toHexString(v), length, 2, leadingZeros ? (char)'0' : ' ', ' ');
    }

    public static StringBuilder formatLong(StringBuilder sb, long v, int length) {
        return FieldFormat.formatLong(sb, v, length, false);
    }

    public static StringBuilder formatLong(StringBuilder sb, long v, int length, boolean leadingZeros) {
        return FieldFormat.format(sb, Long.toString(v), length, leadingZeros ? 2 : 1, leadingZeros ? (char)'0' : ' ', ' ');
    }

    public static StringBuilder format(StringBuilder sb, String chars, int length, int alignment, char preFieldCharacter, char postFieldCharacter) {
        int i;
        int charsCount = chars.length();
        int startAt = 0;
        if (alignment == 2) {
            startAt = length - charsCount;
        } else if (alignment == 3) {
            startAt = (length - charsCount) / 2;
        }
        if (startAt < 0) {
            startAt = 0;
        }
        if (startAt + charsCount > length) {
            charsCount = length - startAt;
        }
        for (i = 0; i < startAt; ++i) {
            sb.append(preFieldCharacter);
        }
        sb.append(chars.substring(0, charsCount));
        for (i = startAt + charsCount; i < length; ++i) {
            sb.append(postFieldCharacter);
        }
        return sb;
    }
}

