/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageRoutedNotifier;
import flex.messaging.client.FlexClient;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.security.LoginManager;
import java.security.Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlexContext {
    private static ThreadLocal<FlexClient> flexClients = new ThreadLocal();
    private static ThreadLocal<FlexSession> sessions = new ThreadLocal();
    private static ThreadLocal<MessageBroker> messageBrokers = new ThreadLocal();
    private static ThreadLocal<Endpoint> endpoints = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> responses = new ThreadLocal();
    private static ThreadLocal<HttpServletRequest> requests = new ThreadLocal();
    private static ThreadLocal<HttpServletRequest> tunnelRequests = new ThreadLocal();
    private static ThreadLocal<ServletConfig> servletConfigs = new ThreadLocal();
    private static ThreadLocal<Boolean> messageFromPeer = new ThreadLocal();
    private static ThreadLocal<MessageRoutedNotifier> messageRoutedNotifiers = new ThreadLocal();
    private static ServletConfig lastGoodServletConfig;

    private FlexContext() {
    }

    public static void setThreadLocalObjects(FlexClient flexClient, FlexSession session, MessageBroker broker, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        if (flexClients == null) {
            return;
        }
        flexClients.set(flexClient);
        sessions.set(session);
        messageBrokers.set(broker);
        requests.set(request);
        responses.set(response);
        FlexContext.setThreadLocalServletConfig(servletConfig);
        messageFromPeer.set(Boolean.FALSE);
    }

    public static void setThreadLocalObjects(FlexClient flexClient, FlexSession session, MessageBroker broker) {
        FlexContext.setThreadLocalObjects(flexClient, session, broker, null, null, null);
    }

    public static void clearThreadLocalObjects() {
        if (flexClients == null) {
            return;
        }
        flexClients.remove();
        sessions.remove();
        messageBrokers.remove();
        endpoints.remove();
        requests.remove();
        responses.remove();
        tunnelRequests.remove();
        servletConfigs.remove();
        messageFromPeer.remove();
        messageRoutedNotifiers.remove();
        TypeMarshallingContext.clearThreadLocalObjects();
    }

    public static HttpServletRequest getHttpRequest() {
        return requests != null ? requests.get() : null;
    }

    public static void setThreadLocalHttpRequest(HttpServletRequest value) {
        if (requests == null) {
            return;
        }
        if (value == null) {
            requests.remove();
        } else {
            requests.set(value);
        }
    }

    public static HttpServletResponse getHttpResponse() {
        return responses != null ? responses.get() : null;
    }

    public static void setThreadLocalHttpResponse(HttpServletResponse value) {
        if (responses == null) {
            return;
        }
        if (value == null) {
            responses.remove();
        } else {
            responses.set(value);
        }
    }

    public static HttpServletRequest getTunnelHttpRequest() {
        return tunnelRequests != null ? tunnelRequests.get() : null;
    }

    public static void setThreadLocalTunnelHttpRequest(HttpServletRequest value) {
        if (tunnelRequests == null) {
            return;
        }
        if (value == null) {
            tunnelRequests.remove();
        } else {
            tunnelRequests.set(value);
        }
    }

    public static ServletConfig getServletConfig() {
        if (servletConfigs != null && servletConfigs.get() != null) {
            return servletConfigs.get();
        }
        return lastGoodServletConfig;
    }

    public static void setThreadLocalServletConfig(ServletConfig value) {
        if (servletConfigs == null) {
            return;
        }
        if (value == null) {
            servletConfigs.remove();
        } else {
            servletConfigs.set(value);
            lastGoodServletConfig = value;
        }
    }

    public static ServletContext getServletContext() {
        return FlexContext.getServletConfig() != null ? FlexContext.getServletConfig().getServletContext() : null;
    }

    public static FlexClient getFlexClient() {
        return flexClients != null ? flexClients.get() : null;
    }

    public static void setThreadLocalFlexClient(FlexClient flexClient) {
        if (flexClients == null) {
            return;
        }
        if (flexClient == null) {
            flexClients.remove();
        } else {
            flexClients.set(flexClient);
        }
    }

    public static FlexSession getFlexSession() {
        return sessions != null ? sessions.get() : null;
    }

    public static void setThreadLocalSession(FlexSession session) {
        if (sessions == null) {
            return;
        }
        if (session == null) {
            sessions.remove();
        } else {
            sessions.set(session);
        }
    }

    public static MessageBroker getMessageBroker() {
        return messageBrokers != null ? messageBrokers.get() : null;
    }

    public static void setThreadLocalMessageBroker(MessageBroker value) {
        if (messageBrokers == null) {
            messageBrokers = new ThreadLocal();
        }
        if (value == null) {
            messageBrokers.remove();
        } else {
            messageBrokers.set(value);
        }
    }

    public static Endpoint getEndpoint() {
        return endpoints != null ? endpoints.get() : null;
    }

    public static void setThreadLocalEndpoint(Endpoint value) {
        if (endpoints == null) {
            return;
        }
        if (value == null) {
            endpoints.remove();
        } else {
            endpoints.set(value);
        }
    }

    public static MessageRoutedNotifier getMessageRoutedNotifier() {
        return messageRoutedNotifiers != null ? messageRoutedNotifiers.get() : null;
    }

    public static void setMessageRoutedNotifier(MessageRoutedNotifier value) {
        if (messageRoutedNotifiers == null) {
            return;
        }
        if (value == null) {
            messageRoutedNotifiers.remove();
        } else {
            messageRoutedNotifiers.set(value);
        }
    }

    public static boolean isMessageFromPeer() {
        return messageFromPeer != null ? messageFromPeer.get() : false;
    }

    public static void setMessageFromPeer(boolean value) {
        if (messageFromPeer == null) {
            return;
        }
        messageFromPeer.set(value);
    }

    public static boolean isPerClientAuthentication() {
        MessageBroker messageBroker = FlexContext.getMessageBroker();
        if (messageBroker == null) {
            return false;
        }
        LoginManager loginManager = messageBroker.getLoginManager();
        return loginManager == null ? false : loginManager.isPerClientAuthentication();
    }

    public static Principal getUserPrincipal() {
        if (FlexContext.isPerClientAuthentication()) {
            FlexClient client = FlexContext.getFlexClient();
            return client != null ? client.getUserPrincipal() : null;
        }
        FlexSession session = FlexContext.getFlexSession();
        return session != null ? session.getUserPrincipal() : null;
    }

    public static void setUserPrincipal(Principal userPrincipal) {
        if (FlexContext.isPerClientAuthentication()) {
            FlexContext.getFlexClient().setUserPrincipal(userPrincipal);
        } else {
            FlexContext.getFlexSession().setUserPrincipal(userPrincipal);
        }
    }

    public static void createThreadLocalObjects() {
        if (flexClients == null) {
            flexClients = new ThreadLocal();
            sessions = new ThreadLocal();
            messageBrokers = new ThreadLocal();
            endpoints = new ThreadLocal();
            responses = new ThreadLocal();
            requests = new ThreadLocal();
            tunnelRequests = new ThreadLocal();
            servletConfigs = new ThreadLocal();
            messageFromPeer = new ThreadLocal();
            messageRoutedNotifiers = new ThreadLocal();
        }
    }

    public static void releaseThreadLocalObjects() {
        FlexContext.clearThreadLocalObjects();
        flexClients = null;
        sessions = null;
        messageBrokers = null;
        endpoints = null;
        responses = null;
        requests = null;
        tunnelRequests = null;
        servletConfigs = null;
        messageFromPeer = null;
        messageRoutedNotifiers = null;
    }
}

