/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.operators.deduplicate.MiniBatchDeduplicateFunctionBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class ProcTimeMiniBatchDeduplicateKeepLastRowFunction
extends MiniBatchDeduplicateFunctionBase<RowData, RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -8981813609115029119L;
    private final TypeSerializer<RowData> serializer;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final boolean inputInsertOnly;
    private final boolean isStateTtlEnabled;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private transient RecordEqualiser equaliser;

    public ProcTimeMiniBatchDeduplicateKeepLastRowFunction(InternalTypeInfo<RowData> typeInfo, TypeSerializer<RowData> serializer, long stateRetentionTime, boolean generateUpdateBefore, boolean generateInsert, boolean inputInsertOnly, GeneratedRecordEqualiser genRecordEqualiser) {
        super(typeInfo, stateRetentionTime);
        this.serializer = serializer;
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.inputInsertOnly = inputInsertOnly;
        this.genRecordEqualiser = genRecordEqualiser;
        this.isStateTtlEnabled = stateRetentionTime > 0L;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) {
        return this.serializer.copy(input);
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            if (this.inputInsertOnly) {
                DeduplicateFunctionHelper.processLastRowOnProcTime(currentRow, this.generateUpdateBefore, this.generateInsert, this.state, out, this.isStateTtlEnabled, this.equaliser);
                continue;
            }
            DeduplicateFunctionHelper.processLastRowOnChangelog(currentRow, this.generateUpdateBefore, this.state, out, this.isStateTtlEnabled, this.equaliser);
        }
    }
}

