/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;

public final class ReusingKeyGroupedIterator<E>
implements KeyGroupedIterator<E> {
    private final MutableObjectIterator<E> iterator;
    private final TypeSerializer<E> serializer;
    private final TypeComparator<E> comparator;
    private E reuse;
    private E current;
    private E lookahead;
    private ValuesIterator valuesIterator;
    private boolean lookAheadHasNext;
    private boolean done;

    public ReusingKeyGroupedIterator(MutableObjectIterator<E> iterator, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        if (iterator == null || serializer == null || comparator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.serializer = serializer;
        this.comparator = comparator;
        this.reuse = this.serializer.createInstance();
    }

    @Override
    public boolean nextKey() throws IOException {
        if (this.current == null) {
            if (this.done) {
                this.valuesIterator = null;
                return false;
            }
            this.current = this.reuse;
            this.current = this.iterator.next(this.current);
            if (this.current != null) {
                this.comparator.setReference(this.current);
                this.lookAheadHasNext = false;
                this.valuesIterator = new ValuesIterator();
                this.valuesIterator.currentIsUnconsumed = true;
                return true;
            }
            this.valuesIterator = null;
            this.current = null;
            this.done = true;
            return false;
        }
        this.valuesIterator.iteratorAvailable = true;
        if (this.lookAheadHasNext) {
            this.lookAheadHasNext = false;
            this.current = this.lookahead;
            this.lookahead = null;
            this.comparator.setReference(this.current);
            this.valuesIterator.currentIsUnconsumed = true;
            return true;
        }
        while (!this.done && (this.current = this.iterator.next(this.current)) != null) {
            if (this.comparator.equalToReference(this.current)) continue;
            this.comparator.setReference(this.current);
            this.lookAheadHasNext = false;
            this.valuesIterator.currentIsUnconsumed = true;
            return true;
        }
        this.valuesIterator = null;
        this.current = null;
        this.done = true;
        return false;
    }

    public TypeComparator<E> getComparatorWithCurrentReference() {
        return this.comparator;
    }

    @Override
    public E getCurrent() {
        return this.current;
    }

    public ValuesIterator getValues() {
        return this.valuesIterator;
    }

    public final class ValuesIterator
    implements Iterator<E>,
    Iterable<E> {
        private final TypeSerializer<E> serializer;
        private final TypeComparator<E> comparator;
        private E staging;
        private boolean currentIsUnconsumed;
        private boolean iteratorAvailable;

        private ValuesIterator() {
            this.serializer = ReusingKeyGroupedIterator.this.serializer;
            this.comparator = ReusingKeyGroupedIterator.this.comparator;
            this.staging = this.serializer.createInstance();
            this.currentIsUnconsumed = false;
            this.iteratorAvailable = true;
        }

        @Override
        public boolean hasNext() {
            if (ReusingKeyGroupedIterator.this.current == null || ReusingKeyGroupedIterator.this.lookAheadHasNext) {
                return false;
            }
            if (this.currentIsUnconsumed) {
                return true;
            }
            try {
                Object stagingStaging = ReusingKeyGroupedIterator.this.iterator.next(this.staging);
                if (stagingStaging != null) {
                    this.staging = stagingStaging;
                    if (this.comparator.equalToReference(this.staging)) {
                        Object tmp = this.staging;
                        this.staging = ReusingKeyGroupedIterator.this.current;
                        ReusingKeyGroupedIterator.this.current = tmp;
                        this.currentIsUnconsumed = true;
                        return true;
                    }
                    ReusingKeyGroupedIterator.this.lookAheadHasNext = true;
                    ReusingKeyGroupedIterator.this.lookahead = this.staging;
                    this.staging = ReusingKeyGroupedIterator.this.current;
                    return false;
                }
                ReusingKeyGroupedIterator.this.done = true;
                return false;
            }
            catch (IOException ioex) {
                throw new RuntimeException("An error occurred while reading the next record: " + ioex.getMessage(), ioex);
            }
        }

        @Override
        public E next() {
            if (this.currentIsUnconsumed || this.hasNext()) {
                this.currentIsUnconsumed = false;
                return ReusingKeyGroupedIterator.this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iteratorAvailable) {
                this.iteratorAvailable = false;
                return this;
            }
            throw new TraversableOnceException();
        }
    }
}

