/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartition;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <K, V> Map<K, V> subtractMap(Map<? extends K, ? extends V> minuend, Map<? extends K, ? extends V> subtrahend) {
        return minuend.entrySet().stream().filter(entry -> !subtrahend.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T> Map<String, Map<Integer, T>> groupPartitionDataByTopic(Map<TopicPartition, ? extends T> data) {
        HashMap<String, Map<Integer, T>> dataByTopic = new HashMap<String, Map<Integer, T>>();
        for (Map.Entry<TopicPartition, T> entry : data.entrySet()) {
            String topic = entry.getKey().topic();
            int partition = entry.getKey().partition();
            Map topicData = dataByTopic.computeIfAbsent(topic, t -> new HashMap());
            topicData.put(partition, entry.getValue());
        }
        return dataByTopic;
    }

    public static Map<String, List<Integer>> groupPartitionsByTopic(Collection<TopicPartition> partitions) {
        HashMap<String, List<Integer>> partitionsByTopic = new HashMap<String, List<Integer>>();
        for (TopicPartition tp : partitions) {
            String topic = tp.topic();
            List topicData = partitionsByTopic.computeIfAbsent(topic, t -> new ArrayList());
            topicData.add(tp.partition());
        }
        return partitionsByTopic;
    }
}

