/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.flink.runtime.security.NoMatchSecurityFactoryException;
import org.apache.flink.runtime.security.contexts.SecurityContextFactory;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.apache.flink.util.Preconditions;

public class SecurityFactoryServiceLoader {
    public static SecurityModuleFactory findModuleFactory(String securityModuleFactoryClass) throws NoMatchSecurityFactoryException {
        return SecurityFactoryServiceLoader.findFactoryInternal(securityModuleFactoryClass, SecurityModuleFactory.class, SecurityModuleFactory.class.getClassLoader());
    }

    public static SecurityContextFactory findContextFactory(String securityContextFactoryClass) throws NoMatchSecurityFactoryException {
        return SecurityFactoryServiceLoader.findFactoryInternal(securityContextFactoryClass, SecurityContextFactory.class, SecurityContextFactory.class.getClassLoader());
    }

    private static <T> T findFactoryInternal(String factoryClassCanonicalName, Class<T> factoryClass, ClassLoader classLoader) throws NoMatchSecurityFactoryException {
        Preconditions.checkNotNull(factoryClassCanonicalName);
        ServiceLoader<T> serviceLoader = classLoader != null ? ServiceLoader.load(factoryClass, classLoader) : ServiceLoader.load(factoryClass);
        ArrayList matchingFactories = new ArrayList();
        Iterator<T> classFactoryIterator = serviceLoader.iterator();
        classFactoryIterator.forEachRemaining(classFactory -> {
            if (factoryClassCanonicalName.matches(classFactory.getClass().getCanonicalName())) {
                matchingFactories.add(classFactory);
            }
        });
        if (matchingFactories.size() != 1) {
            throw new NoMatchSecurityFactoryException("zero or more than one security factory found", factoryClassCanonicalName, matchingFactories);
        }
        return (T)matchingFactories.get(0);
    }
}

