/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.QueueConnectionImpl;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class ReadyForEventsOp {
    public static void execute(ExecutablePool pool, QueueConnectionImpl primary) {
        ReadyForEventsOpImpl op = new ReadyForEventsOpImpl();
        pool.executeOn(primary, (Op)op);
    }

    private ReadyForEventsOp() {
    }

    private static class ReadyForEventsOpImpl
    extends AbstractOp {
        public ReadyForEventsOpImpl() {
            super(53, 1);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "readyForEvents");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startReadyForEvents();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endReadyForEventsSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endReadyForEvents(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

