/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.grails.datastore.mapping.reflect.ReflectionUtils;
import org.springframework.core.env.PropertyResolver;

public class ConfigurationUtils {
    public static <T> Iterable<T> findServices(PropertyResolver configuration, String configurationKey, Class<T> serviceType) {
        List servicesList = configuration.getProperty(configurationKey, List.class, Collections.emptyList());
        return ConfigurationUtils.findServices(servicesList, serviceType);
    }

    public static <T> Iterable<T> findServices(List servicesList, Class<T> serviceType) {
        ArrayList<Object> services = new ArrayList<Object>();
        if (servicesList != null) {
            for (Object serviceObject : servicesList) {
                if (serviceType.isInstance(serviceObject)) {
                    services.add(serviceObject);
                    continue;
                }
                Class serviceTypeClass = null;
                if (serviceObject instanceof Class) {
                    serviceTypeClass = (Class)serviceObject;
                } else if (serviceObject instanceof CharSequence) {
                    serviceTypeClass = ReflectionUtils.forName(serviceObject.toString(), ConfigurationUtils.class.getClassLoader());
                }
                if (serviceTypeClass == null || !serviceType.isAssignableFrom(serviceTypeClass)) continue;
                Object serviceInstance = ReflectionUtils.instantiate(serviceTypeClass);
                services.add(serviceInstance);
            }
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType, ConfigurationUtils.class.getClassLoader());
        for (T service2 : serviceLoader) {
            services.add(service2);
        }
        return services;
    }
}

