/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.List;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class AnnotationContractParameterVisitor
extends BaseVisitor {
    private MethodNode currentMethodNode;

    public AnnotationContractParameterVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    public void visitClass(ClassNode node) {
        if (node == null) {
            return;
        }
        super.visitClass(node.getSuperClass());
        for (ClassNode i : node.getAllInterfaces()) {
            super.visitClass(i);
        }
    }

    public void visitMethod(MethodNode node) {
        this.currentMethodNode = node;
        super.visitMethod(node);
        this.currentMethodNode = null;
    }

    public void visitAnnotations(AnnotatedNode node) {
        if (!(node instanceof Parameter) || this.currentMethodNode == null) {
            return;
        }
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations(node, "org.apache.groovy.contracts.annotations.meta.ContractElement");
    }
}

