/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4.boxes;

import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.boxes.Box;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.RuntimeSAXException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class TikaUserDataBox
extends Box {
    private static final String LOCATION_CODE = "\u00a9xyz";
    private static final String META = "meta";
    private static final String ILST = "ilst";
    private static final String MDTA = "mdta";
    private static final String HDLR = "hdlr";
    private static final String MDIR = "mdir";
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([+-]\\d+\\.\\d+)([+-]\\d+\\.\\d+)");
    @Nullable
    private String coordinateString;
    private boolean isQuickTime = false;
    private final Metadata metadata;
    private final XHTMLContentHandler xhtml;

    public TikaUserDataBox(@NotNull Box box, byte[] payload, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException {
        super(box);
        long size;
        this.metadata = metadata;
        this.xhtml = xhtml;
        int length = payload.length;
        SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
        while (reader.getPosition() < (long)length && (size = reader.getUInt32()) > 4L) {
            String kindName = reader.getString(4, StandardCharsets.ISO_8859_1);
            if (LOCATION_CODE.equals(kindName)) {
                int xyzLength = reader.getUInt16();
                reader.skip(2L);
                this.coordinateString = reader.getString(xyzLength, "UTF-8");
                continue;
            }
            if (META.equals(kindName)) {
                reader.getUInt32();
                long lengthToStartOfList = reader.getUInt32() - 4L;
                if (lengthToStartOfList < 0L || lengthToStartOfList > Integer.MAX_VALUE) {
                    return;
                }
                String hdlr = reader.getString(4, StandardCharsets.ISO_8859_1);
                reader.getUInt32();
                reader.getUInt32();
                String subtype = reader.getString(4, StandardCharsets.ISO_8859_1);
                if (HDLR.equals(hdlr) && MDTA.equals(subtype)) {
                    this.isQuickTime = true;
                }
                int read = 16;
                this.parseUserDataBox((SequentialReader)reader, subtype, read, (int)lengthToStartOfList);
                continue;
            }
            if (size < 8L) {
                return;
            }
            reader.skip(size - 8L);
        }
    }

    private void parseUserDataBox(SequentialReader reader, String handlerType, int read, int lengthToStartOfList) throws IOException {
        if (!MDIR.equals(handlerType)) {
            return;
        }
        if (lengthToStartOfList < read) {
            return;
        }
        int toSkip = lengthToStartOfList - read;
        reader.skip((long)toSkip);
        long len = reader.getUInt32();
        if (len >= Integer.MAX_VALUE || len <= 0L) {
            return;
        }
        String subType = reader.getString(4, StandardCharsets.ISO_8859_1);
        while (!subType.equals(ILST)) {
            reader.skip(len - 8L);
            len = reader.getUInt32();
            subType = reader.getString(4, StandardCharsets.ISO_8859_1);
        }
        if (ILST.equals(subType)) {
            this.processIList(reader, len);
        }
    }

    private void processIList(SequentialReader reader, long totalLen) throws IOException {
        long totalRead = 0L;
        while (totalRead < totalLen) {
            long recordLen = reader.getUInt32();
            String fieldName = reader.getString(4, StandardCharsets.ISO_8859_1);
            long fieldLen = reader.getUInt32();
            String typeName = reader.getString(4, StandardCharsets.ISO_8859_1);
            totalRead += 16L;
            if ("data".equals(typeName)) {
                reader.skip(8L);
                totalRead += 8L;
                int toRead = (int)fieldLen - 16;
                if (toRead <= 0) {
                    return;
                }
                if ("covr".equals(fieldName)) {
                    reader.skip((long)toRead);
                } else if ("cpil".equals(fieldName)) {
                    byte compilationId = reader.getByte();
                    this.metadata.set(XMPDM.COMPILATION, (int)compilationId);
                } else if ("trkn".equals(fieldName)) {
                    if (toRead == 8) {
                        long numA = reader.getUInt32();
                        long numB = reader.getUInt32();
                        this.metadata.set(XMPDM.TRACK_NUMBER, (int)numA);
                    } else {
                        reader.skip((long)toRead);
                    }
                } else if ("disk".equals(fieldName)) {
                    int a = reader.getInt32();
                    short b = reader.getInt16();
                    this.metadata.set(XMPDM.DISC_NUMBER, a);
                } else {
                    String val = reader.getString(toRead, StandardCharsets.UTF_8);
                    try {
                        this.addMetadata(fieldName, val);
                    }
                    catch (SAXException e) {
                        throw new RuntimeSAXException(e);
                    }
                }
                totalRead += (long)toRead;
                continue;
            }
            int toSkip = (int)recordLen - 16;
            if (toSkip <= 0) {
                return;
            }
            reader.skip((long)toSkip);
            totalRead += (long)toSkip;
        }
    }

    private void addMetadata(String key, String value) throws SAXException {
        switch (key) {
            case "\u00a9nam": {
                this.metadata.set(TikaCoreProperties.TITLE, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9too": {
                this.metadata.set(XMP.CREATOR_TOOL, value);
                break;
            }
            case "\u00a9ART": {
                this.metadata.set(XMPDM.ARTIST, value);
                this.metadata.set(TikaCoreProperties.CREATOR, value);
                this.xhtml.element("p", value);
                break;
            }
            case "aART": {
                this.metadata.set(XMPDM.ALBUM_ARTIST, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9wrt": {
                this.metadata.set(XMPDM.COMPOSER, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9alb": {
                this.metadata.set(XMPDM.ALBUM, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9gen": {
                this.metadata.set(XMPDM.GENRE, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9day": {
                this.metadata.set(XMPDM.RELEASE_DATE, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9cmt": {
                this.metadata.set(XMPDM.LOG_COMMENT, value);
                this.xhtml.element("p", value);
                break;
            }
            case "cprt": {
                this.metadata.set(XMPDM.COPYRIGHT, value);
                this.xhtml.element("p", value);
                break;
            }
            case "keyw": {
                this.metadata.set(TikaCoreProperties.SUBJECT, value);
                this.xhtml.element("p", value);
                break;
            }
            case "\u00a9lyr": {
                this.xhtml.element("p", value);
                break;
            }
            case "ldes": 
            case "desc": {
                this.metadata.set(TikaCoreProperties.DESCRIPTION, value);
                this.xhtml.element("p", value);
                break;
            }
            case "xid ": {
                this.metadata.set(XMP.IDENTIFIER, value);
            }
        }
    }

    public void addMetadata(Mp4Directory directory) {
        Matcher matcher;
        if (this.coordinateString != null && (matcher = COORDINATE_PATTERN.matcher(this.coordinateString)).find()) {
            double latitude = Double.parseDouble(matcher.group(1));
            double longitude = Double.parseDouble(matcher.group(2));
            directory.setDouble(8193, latitude);
            directory.setDouble(8194, longitude);
        }
    }
}

