/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;

public class FormulaParser {
    private FormulaMetaFunction formulaMetaFunction;
    private IRowMeta rowMeta;
    private String[] fieldNames;
    private String formula;
    private List<String> formulaFieldList;
    private Object[] dataRow;
    private Row sheetRow;
    private FormulaEvaluator evaluator;

    public FormulaParser(FormulaMetaFunction formulaMetaFunction, IRowMeta rowMeta, Object[] dataRow, Row sheetRow) {
        this.formulaMetaFunction = formulaMetaFunction;
        this.rowMeta = rowMeta;
        this.dataRow = dataRow;
        this.sheetRow = sheetRow;
        this.fieldNames = rowMeta.getFieldNames();
        this.formula = formulaMetaFunction.getFormula();
        this.evaluator = sheetRow.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        this.formulaFieldList = new ArrayList<String>();
        Pattern regex = Pattern.compile("\\[(.*?)\\]");
        Matcher regexMatcher = regex.matcher(this.formula);
        while (regexMatcher.find()) {
            this.formulaFieldList.add(regexMatcher.group(1));
        }
    }

    public CellValue getFormulaValue() {
        String parsedFormula = this.formula;
        int fieldIndex = 65;
        int colIndex = 0;
        for (String formulaField : this.formulaFieldList) {
            char s = (char)fieldIndex;
            Cell cell = this.sheetRow.createCell(colIndex);
            int fieldPosition = this.rowMeta.indexOfValue(formulaField);
            IValueMeta fieldMeta = this.rowMeta.getValueMeta(fieldPosition);
            if (fieldMeta.isBoolean()) {
                cell.setCellValue(((Boolean)this.dataRow[fieldPosition]).booleanValue());
            } else if (fieldMeta.isBigNumber()) {
                cell.setCellValue((RichTextString)this.dataRow[fieldPosition]);
            } else if (fieldMeta.isDate()) {
                cell.setCellValue((Date)this.dataRow[fieldPosition]);
            } else if (fieldMeta.isInteger()) {
                cell.setCellValue((double)((Long)this.dataRow[fieldPosition]).longValue());
            } else if (fieldMeta.isNumber()) {
                cell.setCellValue(((Double)this.dataRow[fieldPosition]).doubleValue());
            } else if (fieldMeta.isString()) {
                cell.setCellValue((String)this.dataRow[fieldPosition]);
            } else if (fieldMeta.getType() == 9) {
                cell.setCellValue((Date)((Timestamp)this.dataRow[fieldPosition]));
            } else {
                cell.setCellValue((String)this.dataRow[fieldPosition]);
            }
            parsedFormula = parsedFormula.replaceAll("\\[" + formulaField + "\\]", s + "1");
            ++fieldIndex;
            ++colIndex;
        }
        Cell formulaCell = this.sheetRow.createCell(colIndex);
        formulaCell.setCellFormula(parsedFormula);
        return this.evaluator.evaluate(formulaCell);
    }
}

