/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.coders;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.SdkHttpMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public final class AwsCoders {
    private AwsCoders() {
    }

    public static Coder<ResponseMetadata> responseMetadata() {
        return ResponseMetadataCoder.of();
    }

    public static Coder<SdkHttpMetadata> sdkHttpMetadata() {
        return new SdkHttpMetadataCoder(true);
    }

    public static Coder<SdkHttpMetadata> sdkHttpMetadataWithoutHeaders() {
        return new SdkHttpMetadataCoder(false);
    }

    private static class SdkHttpMetadataCoder
    extends CustomCoder<SdkHttpMetadata> {
        private static final Coder<Integer> STATUS_CODE_CODER = VarIntCoder.of();
        private static final Coder<Map<String, String>> HEADERS_ENCODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
        private final boolean includeHeaders;

        protected SdkHttpMetadataCoder(boolean includeHeaders) {
            this.includeHeaders = includeHeaders;
        }

        public void encode(SdkHttpMetadata value, OutputStream outStream) throws CoderException, IOException {
            STATUS_CODE_CODER.encode((Object)value.getHttpStatusCode(), outStream);
            if (this.includeHeaders) {
                HEADERS_ENCODER.encode((Object)value.getHttpHeaders(), outStream);
            }
        }

        public SdkHttpMetadata decode(InputStream inStream) throws CoderException, IOException {
            int httpStatusCode = (Integer)STATUS_CODE_CODER.decode(inStream);
            HttpResponse httpResponse = new HttpResponse(null, null);
            httpResponse.setStatusCode(httpStatusCode);
            if (this.includeHeaders) {
                Optional.ofNullable((Map)HEADERS_ENCODER.decode(inStream)).ifPresent(headers -> headers.keySet().forEach(k -> httpResponse.addHeader(k, (String)headers.get(k))));
            }
            return SdkHttpMetadata.from((HttpResponse)httpResponse);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            STATUS_CODE_CODER.verifyDeterministic();
            if (this.includeHeaders) {
                HEADERS_ENCODER.verifyDeterministic();
            }
        }
    }

    private static class ResponseMetadataCoder
    extends AtomicCoder<ResponseMetadata> {
        private static final Coder<Map<String, String>> METADATA_ENCODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
        private static final ResponseMetadataCoder INSTANCE = new ResponseMetadataCoder();

        private ResponseMetadataCoder() {
        }

        public static ResponseMetadataCoder of() {
            return INSTANCE;
        }

        public void encode(ResponseMetadata value, OutputStream outStream) throws CoderException, IOException {
            METADATA_ENCODER.encode((Object)ImmutableMap.of((Object)"AWS_REQUEST_ID", (Object)value.getRequestId()), outStream);
        }

        public ResponseMetadata decode(InputStream inStream) throws CoderException, IOException {
            return new ResponseMetadata((Map)METADATA_ENCODER.decode(inStream));
        }
    }
}

