/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.repeat;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.repeat.ParameterDetails;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Action(id="Repeat", name="i18n::Repeat.Name", description="i18n::Repeat.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::Repeat.keywords"}, image="repeat.svg", documentationUrl="/workflow/actions/repeat.html")
public class Repeat
extends ActionBase
implements IAction,
Cloneable {
    public static final String REPEAT_END_LOOP = "_REPEAT_END_LOOP_";
    public static final String FILENAME = "filename";
    public static final String RUN_CONFIGURATION = "run_configuration";
    public static final String VARIABLE_NAME = "variable_name";
    public static final String VARIABLE_VALUE = "variable_value";
    public static final String DELAY = "delay";
    public static final String KEEP_VALUES = "keep_values";
    public static final String LOGFILE_ENABLED = "logfile_enabled";
    public static final String LOGFILE_APPENDED = "logfile_appended";
    public static final String LOGFILE_BASE = "logfile_base";
    public static final String LOGFILE_EXTENSION = "logfile_extension";
    public static final String LOGFILE_ADD_DATE = "logfile_add_date";
    public static final String LOGFILE_ADD_TIME = "logfile_add_time";
    public static final String LOGFILE_ADD_REPETITION = "logfile_add_repetition";
    public static final String LOGFILE_UPDATE_INTERVAL = "logfile_update_interval";
    public static final String PARAMETERS = "parameters";
    public static final String PARAMETER = "parameter";
    private String filename;
    private List<ParameterDetails> parameters = new ArrayList<ParameterDetails>();
    private String variableName;
    private String variableValue;
    private String delay;
    private boolean keepingValues;
    private String runConfigurationName;
    private boolean logFileEnabled;
    private String logFileBase;
    private String logFileExtension = "log";
    private boolean logFileAppended = true;
    private boolean logFileDateAdded = true;
    private boolean logFileTimeAdded = false;
    private boolean logFileRepetitionAdded = false;
    private String logFileUpdateInterval = "5000";

    public Repeat(String name, String description) {
        super(name, description);
    }

    public Repeat() {
        this("", "");
    }

    public Repeat clone() {
        return (Repeat)super.clone();
    }

    public Result execute(Result prevResult, int nr) throws HopException {
        String realFilename = this.resolve(this.filename);
        if (StringUtils.isEmpty((String)realFilename)) {
            throw new HopException("Please specify a transformation or workflow to repeat");
        }
        long delayInMs = -1L;
        if (StringUtils.isNotEmpty((String)this.delay)) {
            String realDelay = this.resolve(this.delay);
            delayInMs = Const.toLong((String)realDelay, (long)-1L);
            if (delayInMs < 0L) {
                throw new HopException("Unable to parse delay for string: " + realDelay);
            }
            delayInMs *= 1000L;
        }
        this.getExtensionDataMap().remove(REPEAT_END_LOOP);
        if (this.isVariableValueSet((IVariables)this)) {
            return prevResult;
        }
        ExecutionResult executionResult = null;
        boolean repeat = true;
        int repetitionNr = 0;
        while (repeat && !this.parentWorkflow.isStopped()) {
            executionResult = this.executeTransformationOrWorkflow(realFilename, nr, executionResult, ++repetitionNr);
            Result result = executionResult.result;
            if (!result.getResult() || result.getNrErrors() > 0L || result.isStopped()) {
                this.log.logError("The repeating work encountered and error or was stopped. This ends the loop.");
                prevResult.setResult(false);
                repeat = false;
            } else if (executionResult.flagSet) {
                repeat = false;
            } else {
                boolean bl = repeat = !this.isVariableValueSet(executionResult.variables);
            }
            if (!repeat || delayInMs <= 0L) continue;
            long startTime = System.currentTimeMillis();
            while (!this.parentWorkflow.isStopped() && System.currentTimeMillis() - startTime < delayInMs) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        if (executionResult != null) {
            prevResult.add(executionResult.result);
        }
        return prevResult;
    }

    private ExecutionResult executeTransformationOrWorkflow(String realFilename, int nr, ExecutionResult previousResult, int repetitionNr) throws HopException {
        if (this.isPipeline(realFilename)) {
            return this.executePipeline(realFilename, nr, previousResult, repetitionNr);
        }
        if (this.isWorkflow(realFilename)) {
            return this.executeWorkflow(realFilename, nr, previousResult, repetitionNr);
        }
        throw new HopException("Sorry, I don't know if this is a pipeline or a workflow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionResult executePipeline(String realFilename, int nr, ExecutionResult previousResult, int repetitionNr) throws HopException {
        PipelineMeta pipelineMeta = this.loadPipeline(realFilename, this.getMetadataProvider(), (IVariables)this);
        IPipelineEngine pipeline = PipelineEngineFactory.createPipelineEngine((IVariables)this, (String)this.runConfigurationName, (IHopMetadataProvider)this.getMetadataProvider(), (PipelineMeta)pipelineMeta);
        pipeline.setParentWorkflow(this.getParentWorkflow());
        pipeline.setParent((ILoggingObject)this);
        if (this.keepingValues && previousResult != null) {
            pipeline.copyFrom(previousResult.variables);
        } else {
            pipeline.initializeFrom((IVariables)this.getParentWorkflow());
            pipeline.copyParametersFromDefinitions((INamedParameterDefinitions)pipelineMeta);
        }
        pipeline.getPipelineMeta().setInternalHopVariables((IVariables)pipeline);
        pipeline.setVariables(this.getVariablesMap((INamedParameters)pipeline, previousResult));
        INamedParameters previousParams = previousResult == null ? null : (INamedParameters)previousResult.variables;
        IVariables previousVars = previousResult == null ? null : previousResult.variables;
        this.updateParameters((INamedParameters)pipeline, previousVars, new INamedParameters[]{this.getParentWorkflow(), previousParams});
        pipeline.setLogLevel(this.getLogLevel());
        pipeline.setMetadataProvider(this.getMetadataProvider());
        LogChannelFileWriter fileWriter = null;
        try {
            if (this.logFileEnabled) {
                fileWriter = this.logToFile((ILoggingObject)pipeline, repetitionNr);
            }
            pipeline.prepareExecution();
            pipeline.startThreads();
            pipeline.waitUntilFinished();
            boolean flagSet = pipeline.getExtensionDataMap().get(REPEAT_END_LOOP) != null;
            Result result = pipeline.getResult();
            ExecutionResult executionResult = new ExecutionResult(result, (IVariables)pipeline, flagSet);
            return executionResult;
        }
        finally {
            if (this.logFileEnabled && fileWriter != null) {
                fileWriter.stopLogging();
            }
        }
    }

    private LogChannelFileWriter logToFile(ILoggingObject loggingObject, int repetitionNr) throws HopException {
        Date currentDate = new Date();
        Object filename = this.resolve(this.logFileBase);
        if (this.logFileDateAdded) {
            filename = (String)filename + "_" + new SimpleDateFormat("yyyyMMdd").format(currentDate);
        }
        if (this.logFileTimeAdded) {
            filename = (String)filename + "_" + new SimpleDateFormat("HHmmss").format(currentDate);
        }
        if (this.logFileRepetitionAdded) {
            filename = (String)filename + "_" + new DecimalFormat("0000").format(repetitionNr);
        }
        filename = (String)filename + "." + this.resolve(this.logFileExtension);
        String logChannelId = loggingObject.getLogChannelId();
        LogChannelFileWriter fileWriter = new LogChannelFileWriter(logChannelId, HopVfs.getFileObject((String)filename), this.logFileAppended, Const.toInt((String)this.logFileUpdateInterval, (int)5000));
        fileWriter.startLogging();
        return fileWriter;
    }

    private Map<String, String> getVariablesMap(INamedParameters namedParams, ExecutionResult previousResult) {
        String[] params = namedParams.listParameters();
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        if (this.keepingValues && previousResult != null) {
            for (String variableName : previousResult.variables.getVariableNames()) {
                variablesMap.put(variableName, previousResult.variables.getVariable(variableName));
            }
        } else {
            for (ParameterDetails parameter : this.parameters) {
                String value = this.resolve(parameter.getField());
                variablesMap.put(parameter.getName(), value);
            }
        }
        return variablesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionResult executeWorkflow(String realFilename, int nr, ExecutionResult previousResult, int repetitionNr) throws HopException {
        WorkflowMeta workflowMeta = this.loadWorkflow(realFilename, this.getMetadataProvider(), (IVariables)this);
        IWorkflowEngine workflow = WorkflowEngineFactory.createWorkflowEngine((IVariables)this, (String)this.runConfigurationName, (IHopMetadataProvider)this.getMetadataProvider(), (WorkflowMeta)workflowMeta, (ILoggingObject)this);
        workflow.setParentWorkflow(this.getParentWorkflow());
        workflow.setParentVariables((IVariables)this);
        if (this.keepingValues && previousResult != null) {
            workflow.copyFrom(previousResult.variables);
        } else {
            workflow.initializeFrom((IVariables)this);
            workflow.copyParametersFromDefinitions((INamedParameterDefinitions)workflowMeta);
        }
        workflow.getWorkflowMeta().setInternalHopVariables((IVariables)workflow);
        workflow.setVariables(this.getVariablesMap((INamedParameters)workflow, previousResult));
        INamedParameters previousParams = previousResult == null ? null : (INamedParameters)previousResult.variables;
        IVariables previousVars = previousResult == null ? null : previousResult.variables;
        this.updateParameters((INamedParameters)workflow, previousVars, new INamedParameters[]{this.getParentWorkflow(), previousParams});
        workflow.setLogLevel(this.getLogLevel());
        if (this.parentWorkflow.isInteractive()) {
            workflow.setInteractive(true);
            workflow.getActionListeners().addAll(this.parentWorkflow.getActionListeners());
        }
        this.parentWorkflow.getWorkflowTracker().addWorkflowTracker(workflow.getWorkflowTracker());
        workflow.getWorkflowTracker().setParentWorkflowTracker(this.parentWorkflow.getWorkflowTracker());
        LogChannelFileWriter fileWriter = null;
        try {
            boolean flagSet;
            if (this.logFileEnabled) {
                fileWriter = this.logToFile((ILoggingObject)workflow, repetitionNr);
            }
            Result result = workflow.startExecution();
            boolean bl = flagSet = workflow.getExtensionDataMap().get(REPEAT_END_LOOP) != null;
            if (flagSet) {
                this.log.logBasic("End loop flag found, stopping loop.");
            }
            ExecutionResult executionResult = new ExecutionResult(result, (IVariables)workflow, flagSet);
            return executionResult;
        }
        finally {
            if (this.logFileEnabled && fileWriter != null) {
                fileWriter.stopLogging();
            }
        }
    }

    private void updateParameters(INamedParameters subParams, IVariables subVars, INamedParameters ... params) {
        for (INamedParameters param : params) {
            if (param == null) continue;
        }
        String[] parameterNames = subParams.listParameters();
        for (ParameterDetails parameter : this.parameters) {
            if (Const.indexOfString((String)parameter.getName(), (String[])parameterNames) < 0) continue;
            String value = this.resolve(parameter.getField());
            try {
                subParams.setParameterValue(parameter.getName(), value);
            }
            catch (UnknownParamException unknownParamException) {}
        }
        if (this.keepingValues && subVars != null) {
            for (String parameterName : subParams.listParameters()) {
                try {
                    String value = subVars.getVariable(parameterName);
                    subParams.setParameterValue(parameterName, value);
                }
                catch (UnknownParamException unknownParamException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isVariableValueSet(IVariables variables) {
        if (StringUtils.isNotEmpty((String)this.variableName)) {
            String realVariable = variables.resolve(this.variableName);
            String value = variables.getVariable(realVariable);
            if (StringUtil.isEmpty((String)value)) {
                return false;
            }
            String realValue = this.resolve(this.variableValue);
            if (StringUtils.isEmpty((String)realValue)) {
                return true;
            }
            return realValue.equalsIgnoreCase(value);
        }
        return false;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(super.getXml());
        xml.append(XmlHandler.addTagValue((String)FILENAME, (String)this.filename));
        xml.append(XmlHandler.addTagValue((String)RUN_CONFIGURATION, (String)this.runConfigurationName));
        xml.append(XmlHandler.addTagValue((String)VARIABLE_NAME, (String)this.variableName));
        xml.append(XmlHandler.addTagValue((String)VARIABLE_VALUE, (String)this.variableValue));
        xml.append(XmlHandler.addTagValue((String)DELAY, (String)this.delay));
        xml.append(XmlHandler.addTagValue((String)KEEP_VALUES, (boolean)this.keepingValues));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_ENABLED, (boolean)this.logFileEnabled));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_APPENDED, (boolean)this.logFileAppended));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_BASE, (String)this.logFileBase));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_EXTENSION, (String)this.logFileExtension));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_ADD_DATE, (boolean)this.logFileDateAdded));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_ADD_TIME, (boolean)this.logFileTimeAdded));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_ADD_REPETITION, (boolean)this.logFileRepetitionAdded));
        xml.append(XmlHandler.addTagValue((String)LOGFILE_UPDATE_INTERVAL, (String)this.logFileUpdateInterval));
        xml.append(XmlHandler.openTag((String)PARAMETERS));
        for (ParameterDetails parameter : this.parameters) {
            xml.append(XmlHandler.openTag((String)PARAMETER));
            xml.append(XmlHandler.addTagValue((String)"name", (String)parameter.getName()));
            xml.append(XmlHandler.addTagValue((String)"value", (String)parameter.getField()));
            xml.append(XmlHandler.closeTag((String)PARAMETER));
        }
        xml.append(XmlHandler.closeTag((String)PARAMETERS));
        return xml.toString();
    }

    public void loadXml(Node actionNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        super.loadXml(actionNode);
        this.filename = XmlHandler.getTagValue((Node)actionNode, (String)FILENAME);
        this.runConfigurationName = XmlHandler.getTagValue((Node)actionNode, (String)RUN_CONFIGURATION);
        this.variableName = XmlHandler.getTagValue((Node)actionNode, (String)VARIABLE_NAME);
        this.variableValue = XmlHandler.getTagValue((Node)actionNode, (String)VARIABLE_VALUE);
        this.delay = XmlHandler.getTagValue((Node)actionNode, (String)DELAY);
        this.keepingValues = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)KEEP_VALUES));
        this.logFileEnabled = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_ENABLED));
        this.logFileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_APPENDED));
        this.logFileDateAdded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_ADD_DATE));
        this.logFileTimeAdded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_ADD_TIME));
        this.logFileRepetitionAdded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_ADD_REPETITION));
        this.logFileBase = XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_BASE);
        this.logFileExtension = XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_EXTENSION);
        this.logFileUpdateInterval = XmlHandler.getTagValue((Node)actionNode, (String)LOGFILE_UPDATE_INTERVAL);
        Node parametersNode = XmlHandler.getSubNode((Node)actionNode, (String)PARAMETERS);
        List parameterNodes = XmlHandler.getNodes((Node)parametersNode, (String)PARAMETER);
        this.parameters = new ArrayList<ParameterDetails>();
        for (Node parameterNode : parameterNodes) {
            String name = XmlHandler.getTagValue((Node)parameterNode, (String)"name");
            String field = XmlHandler.getTagValue((Node)parameterNode, (String)"value");
            this.parameters.add(new ParameterDetails(name, field));
        }
    }

    public String[] getReferencedObjectDescriptions() {
        String referenceDescription = StringUtils.isEmpty((String)this.filename) ? "" : (this.filename.toLowerCase().endsWith(".hpl") ? "The repeating pipeline" : (this.filename.toLowerCase().endsWith(".hwf") ? "The repeating workflow" : "The repeating workflow or pipeline"));
        return new String[]{referenceDescription};
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{StringUtils.isNotEmpty((String)this.filename)};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        String realFilename = variables.resolve(this.filename);
        if (this.isPipeline(realFilename)) {
            return this.loadPipeline(realFilename, metadataProvider, variables);
        }
        if (this.isWorkflow(realFilename)) {
            return this.loadWorkflow(realFilename, metadataProvider, variables);
        }
        throw new HopException("Can't tell if this workflow action is referencing a transformation or a workflow");
    }

    public boolean isPipeline(String realFilename) throws HopException {
        if (realFilename.toLowerCase().endsWith(".hpl")) {
            return true;
        }
        try {
            Document document = XmlHandler.loadXmlFile((String)realFilename);
            return XmlHandler.getSubNode((Node)document, (String)"pipeline") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isWorkflow(String realFilename) {
        if (realFilename.toLowerCase().endsWith(".hwf")) {
            return true;
        }
        try {
            Document document = XmlHandler.loadXmlFile((String)realFilename);
            return XmlHandler.getSubNode((Node)document, (String)"workflow") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private PipelineMeta loadPipeline(String realFilename, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        PipelineMeta pipelineMeta = new PipelineMeta(realFilename, metadataProvider, true, variables);
        return pipelineMeta;
    }

    private WorkflowMeta loadWorkflow(String realFilename, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        WorkflowMeta workflowMeta = new WorkflowMeta(variables, realFilename, metadataProvider);
        return workflowMeta;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<ParameterDetails> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDetails> parameters) {
        this.parameters = parameters;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }

    public String getDelay() {
        return this.delay;
    }

    public void setDelay(String delay) {
        this.delay = delay;
    }

    public boolean isKeepingValues() {
        return this.keepingValues;
    }

    public void setKeepingValues(boolean keepingValues) {
        this.keepingValues = keepingValues;
    }

    public boolean isLogFileEnabled() {
        return this.logFileEnabled;
    }

    public void setLogFileEnabled(boolean logFileEnabled) {
        this.logFileEnabled = logFileEnabled;
    }

    public String getLogFileBase() {
        return this.logFileBase;
    }

    public void setLogFileBase(String logFileBase) {
        this.logFileBase = logFileBase;
    }

    public String getLogFileExtension() {
        return this.logFileExtension;
    }

    public void setLogFileExtension(String logFileExtension) {
        this.logFileExtension = logFileExtension;
    }

    public boolean isLogFileAppended() {
        return this.logFileAppended;
    }

    public void setLogFileAppended(boolean logFileAppended) {
        this.logFileAppended = logFileAppended;
    }

    public boolean isLogFileDateAdded() {
        return this.logFileDateAdded;
    }

    public void setLogFileDateAdded(boolean logFileDateAdded) {
        this.logFileDateAdded = logFileDateAdded;
    }

    public boolean isLogFileTimeAdded() {
        return this.logFileTimeAdded;
    }

    public void setLogFileTimeAdded(boolean logFileTimeAdded) {
        this.logFileTimeAdded = logFileTimeAdded;
    }

    public boolean isLogFileRepetitionAdded() {
        return this.logFileRepetitionAdded;
    }

    public void setLogFileRepetitionAdded(boolean logFileRepetitionAdded) {
        this.logFileRepetitionAdded = logFileRepetitionAdded;
    }

    public String getLogFileUpdateInterval() {
        return this.logFileUpdateInterval;
    }

    public void setLogFileUpdateInterval(String logFileUpdateInterval) {
        this.logFileUpdateInterval = logFileUpdateInterval;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    private class ExecutionResult {
        public Result result;
        public IVariables variables;
        public boolean flagSet;

        public ExecutionResult(Result result, IVariables variables, boolean flagSet) {
            this.result = result;
            this.variables = variables;
            this.flagSet = flagSet;
        }
    }
}

