/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.http.HttpRequestor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DbxDownloadStyleBuilder<R> {
    private Long start = null;
    private Long length = null;

    protected DbxDownloadStyleBuilder() {
    }

    protected List<HttpRequestor.Header> getHeaders() {
        if (this.start == null) {
            return Collections.emptyList();
        }
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        String rangeValue = String.format("bytes=%d-", (long)this.start);
        if (this.length != null) {
            rangeValue = rangeValue + Long.toString(this.start + this.length - 1L);
        }
        headers.add(new HttpRequestor.Header("Range", rangeValue));
        return headers;
    }

    public abstract DbxDownloader<R> start() throws DbxException;

    public DbxDownloadStyleBuilder<R> range(long start, long length) {
        if (start < 0L) {
            throw new IllegalArgumentException("start must be non-negative");
        }
        if (length < 1L) {
            throw new IllegalArgumentException("length must be positive");
        }
        this.start = start;
        this.length = length;
        return this;
    }

    public DbxDownloadStyleBuilder<R> range(long start) {
        if (start < 0L) {
            throw new IllegalArgumentException("start must be non-negative");
        }
        this.start = start;
        this.length = null;
        return this;
    }

    public R download(OutputStream out) throws DbxException, IOException {
        return this.start().download(out);
    }
}

